/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service.impl;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.service.CommonTagService;
import com.bxm.localnews.sync.primary.dao.CommonTagMapper;
import com.bxm.localnews.sync.vo.local.CommonTag;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonTagServiceImpl
implements CommonTagService {
    private static final Logger log = LogManager.getLogger(CommonTagServiceImpl.class);
    private final CommonTagMapper commonTagMapper;
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public CommonTagServiceImpl(CommonTagMapper commonTagMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.commonTagMapper = commonTagMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public long saveAndGetTag(String tagName) {
        long hashCode = tagName.hashCode();
        long collectionIndex = hashCode % 10L;
        KeyGenerator tagKey = RedisKey.SPIDER_TAG_INDEX.copy().appendKey((Object)collectionIndex);
        Long id = (Long)this.redisHashMapAdapter.get(tagKey, tagName, Long.class);
        if (null == id) {
            CommonTag tag = this.commonTagMapper.findByName(tagName);
            if (tag == null) {
                tag = new CommonTag();
                tag.setName(tagName);
                if (log.isDebugEnabled()) {
                    log.debug("tag:[{}]", (Object)tag);
                }
                this.commonTagMapper.insert(tag);
            }
            this.redisHashMapAdapter.put(tagKey, tagName, (Object)tag.getId());
            return tag.getId().intValue();
        }
        return id;
    }
}

