/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.service.CommonTagService;
import com.bxm.localnews.service.ForumPostService;
import com.bxm.localnews.service.NewsManageService;
import com.bxm.localnews.service.UserStatisticService;
import com.bxm.localnews.sync.enums.NewsTagTypeEnum;
import com.bxm.localnews.sync.primary.dao.ForumPostMapper;
import com.bxm.localnews.sync.second.dao.SpiderForumPostCommentMapper;
import com.bxm.localnews.sync.second.dao.SpiderForumPostMapper;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.business.ForumPostLike;
import com.bxm.localnews.sync.vo.business.User;
import com.bxm.localnews.sync.vo.local.ForumPost;
import com.bxm.localnews.sync.vo.local.PostTag;
import com.bxm.localnews.sync.vo.spider.SpiderForumPost;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ForumPostServiceImpl
extends BaseService
implements ForumPostService {
    private static final Logger log = LogManager.getLogger(ForumPostServiceImpl.class);
    private final ForumPostMapper forumPostMapper;
    private final SpiderForumPostMapper spiderForumPostMapper;
    private final SpiderForumPostCommentMapper spiderForumPostCommentMapper;
    private final NewsManageService newsManageService;
    private final CommonTagService commonTagService;
    private final UserStatisticService userStatisticService;
    private final RedisStringAdapter redisStringAdapter;
    private final ProcesserChain processerChain;

    @Autowired
    public ForumPostServiceImpl(ForumPostMapper forumPostMapper, SpiderForumPostMapper spiderForumPostMapper, SpiderForumPostCommentMapper spiderForumPostCommentMapper, NewsManageService newsManageService, CommonTagService commonTagService, UserStatisticService userStatisticService, RedisStringAdapter redisStringAdapter, ProcesserChain processerChain) {
        this.forumPostMapper = forumPostMapper;
        this.spiderForumPostMapper = spiderForumPostMapper;
        this.spiderForumPostCommentMapper = spiderForumPostCommentMapper;
        this.newsManageService = newsManageService;
        this.commonTagService = commonTagService;
        this.userStatisticService = userStatisticService;
        this.redisStringAdapter = redisStringAdapter;
        this.processerChain = processerChain;
    }

    @Override
    public void supplementPostTag() {
        List postList = this.forumPostMapper.supplementPostTag();
        for (ForumPost forumPost : postList) {
            List<Keyword> keywords = this.newsManageService.tfidf(forumPost.getTitle(), forumPost.getContent());
            if (log.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                keywords.forEach(word -> sb.append(word).append(","));
                log.debug("tfidfResult -> title:[{}],content:[{}],result:[{}]", (Object)forumPost.getTitle(), (Object)forumPost.getContent(), (Object)sb.toString());
            }
            if (CollectionUtils.isEmpty(keywords)) continue;
            for (Keyword keyword : keywords) {
                PostTag postTag = new PostTag();
                postTag.setId(Long.valueOf(this.nextId()));
                postTag.setName(keyword.getName());
                postTag.setTagType(NewsTagTypeEnum.CHANNEL_TAG.getCode());
                postTag.setWeight(Double.valueOf(keyword.getTfidfvalue()));
                postTag.setPostId(forumPost.getId());
                postTag.setTagId(Long.valueOf(this.commonTagService.saveAndGetTag(keyword.getName())));
                this.forumPostMapper.savePostTag(postTag);
            }
        }
    }

    @Override
    public void scanningForumPost() {
        HashMap<Long, User> userMap = new HashMap<Long, User>();
        List forumPostList = this.forumPostMapper.selectForumPostWithoutUser();
        for (ForumPost forumPost : forumPostList) {
            Long userId = forumPost.getUserId();
            User user = this.userStatisticService.getUserInfo(userMap, userId);
            if (null == user) continue;
            String nickname = user.getNickname();
            String headImg = user.getHeadImg();
            this.forumPostMapper.updateUserInfo(forumPost.getId(), userId, headImg, nickname);
        }
        List list = this.forumPostMapper.selectNotExitsUserInfo();
        ArrayList paramList = Lists.newArrayList();
        list.forEach(e -> {
            ForumPostLike postLike = new ForumPostLike();
            postLike.setUserId(e.getUserId());
            postLike.setId(e.getId());
            User user = this.userStatisticService.getUserInfo(userMap, e.getUserId());
            if (!(!Objects.nonNull(user) || StringUtils.isEmpty((Object)user.getNickname()) && StringUtils.isEmpty((Object)user.getHeadImg()))) {
                postLike.setUserNickname(user.getNickname());
                postLike.setHeadImg(user.getHeadImg());
                paramList.add(postLike);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)paramList)) {
            MybatisBatchBuilder.create(ForumPostMapper.class, (Collection)paramList).sessionTemplateName("primarySessionTemplate").run(ForumPostMapper::updateUserInfoByUserId);
        }
    }

    private void execute(Date limitDate) {
        List spiderForumPosts = this.spiderForumPostMapper.listByLimitDate(limitDate);
        if (CollectionUtils.isEmpty((Collection)spiderForumPosts)) {
            return;
        }
        for (SpiderForumPost spiderForumPost : spiderForumPosts) {
            spiderForumPost.setComments(this.spiderForumPostCommentMapper.ListByPostId(spiderForumPost.getId()));
            ProcesserContext<SpiderForumPost> context = new ProcesserContext<SpiderForumPost>();
            spiderForumPost.setStatus(Byte.valueOf((byte)1));
            context.setData(spiderForumPost);
            this.processerChain.process(context);
        }
        limitDate = ((SpiderForumPost)spiderForumPosts.get(spiderForumPosts.size() - 1)).getCreateTime();
        this.redisStringAdapter.set(RedisKey.SPIDER_FORUM_SYNC, (Object)limitDate);
        this.execute(limitDate);
    }

    @Override
    public void syncPost() {
        Date lastSyncTime = (Date)this.redisStringAdapter.get(RedisKey.SPIDER_FORUM_SYNC, Date.class);
        if (null == lastSyncTime) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -5);
            lastSyncTime = calendar.getTime();
        }
        this.execute(lastSyncTime);
    }
}

