/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.service.NewsInfoSyncService;
import com.bxm.localnews.service.UserStatisticService;
import com.bxm.localnews.sync.primary.dao.NewsInfoSyncMapper;
import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.primary.dao.NewsReplyMapper;
import com.bxm.localnews.sync.primary.dao.UserReplyMapper;
import com.bxm.localnews.sync.vo.business.NewsCommentStatistic;
import com.bxm.localnews.sync.vo.business.User;
import com.bxm.localnews.sync.vo.local.ForumPostStatic;
import com.bxm.localnews.sync.vo.local.NewsReply;
import com.bxm.localnews.thread.NewsCommentSyncThread;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class NewsInfoSyncServiceImpl
implements NewsInfoSyncService {
    private static CountDownLatch countDownLatch = null;
    private static final String primarySessionTemplate = "primarySessionTemplate";
    @Resource
    private NewsInfoSyncMapper newsInfoSyncMapper;
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private UserReplyMapper userReplyMapper;
    @Resource
    private UserStatisticService userStatisticService;
    @Resource
    private NewsMapper newsMapper;
    @Resource
    private AsyncTaskExecutor taskExecutor;

    @Override
    public void execute() {
        List collectPostIds = this.newsInfoSyncMapper.selectCollectPost();
        ArrayList collects = Lists.newArrayList();
        for (Long postid : collectPostIds) {
            ForumPostStatic postStatic = new ForumPostStatic();
            postStatic.setPostId(postid);
            postStatic.setCollectCount(this.newsInfoSyncMapper.selectCollectByPostId(postid));
            collects.add(postStatic);
        }
        if (!CollectionUtils.isEmpty((Collection)collects)) {
            MybatisBatchBuilder.create(NewsInfoSyncMapper.class, (Collection)collects).sessionTemplateName(primarySessionTemplate).limit(500).run(NewsInfoSyncMapper::updateForumPostStaticById);
        }
        List sharePostIds = this.newsInfoSyncMapper.selectSharePostCountNum();
        ArrayList shares = Lists.newArrayList();
        for (Long postid : sharePostIds) {
            ForumPostStatic postStatic = new ForumPostStatic();
            postStatic.setPostId(postid);
            postStatic.setShareCount(this.newsInfoSyncMapper.selectShareCountByPostId(postid));
            shares.add(postStatic);
        }
        if (!CollectionUtils.isEmpty((Collection)shares)) {
            MybatisBatchBuilder.create(NewsInfoSyncMapper.class, (Collection)shares).sessionTemplateName(primarySessionTemplate).limit(500).run(NewsInfoSyncMapper::updateForumPostStaticById);
        }
        List likePostIds = this.newsInfoSyncMapper.selectLikePostCountNum();
        ArrayList likes = Lists.newArrayList();
        for (Long postid : likePostIds) {
            ForumPostStatic postStatic = new ForumPostStatic();
            postStatic.setPostId(postid);
            postStatic.setLikeCount(this.newsInfoSyncMapper.selectLikeCountByPostId(postid));
            likes.add(postStatic);
        }
        if (!CollectionUtils.isEmpty((Collection)likes)) {
            MybatisBatchBuilder.create(NewsInfoSyncMapper.class, (Collection)likes).sessionTemplateName(primarySessionTemplate).limit(500).run(NewsInfoSyncMapper::updateForumPostStaticById);
        }
    }

    @Override
    public void syncNewsComment(List<Long> idList, Integer offset) {
        String tableName = "t_news_reply_" + offset;
        ArrayList<NewsCommentStatistic> newsCommentStatisticList = new ArrayList<NewsCommentStatistic>();
        for (Long id : idList) {
            int newsCommentCount = this.newsInfoSyncMapper.selectNewsCommentCount(tableName, id);
            NewsCommentStatistic newsCommentStatistic = new NewsCommentStatistic(id, Integer.valueOf(newsCommentCount));
            newsCommentStatisticList.add(newsCommentStatistic);
        }
        MybatisBatchBuilder.create(NewsMapper.class, newsCommentStatisticList).sessionTemplateName(primarySessionTemplate).limit(500).run(NewsMapper::updateNewsCommentById);
    }

    @Override
    public void syncNewsReply() {
        HashMap<Long, User> userMap = new HashMap<Long, User>();
        ArrayList<NewsReply> waitForUpdateNewsReplyList = new ArrayList<NewsReply>();
        List newsReplyList = this.newsReplyMapper.selectWithoutUser();
        for (NewsReply newsReply : newsReplyList) {
            User parentUser;
            User user = this.userStatisticService.getUserInfo(userMap, newsReply.getUserId());
            if (Objects.nonNull(user)) {
                newsReply.setUserNickname(user.getNickname());
                newsReply.setHeadImg(user.getHeadImg());
            }
            if (newsReply.getParentUserId() != null && Objects.nonNull(parentUser = this.userStatisticService.getUserInfo(userMap, newsReply.getParentUserId()))) {
                newsReply.setParentUserNickname(parentUser.getNickname());
                newsReply.setParentHeadImg(parentUser.getHeadImg());
            }
            if (StringUtils.isEmpty((Object)newsReply.getParentUserNickname()) && StringUtils.isEmpty((Object)newsReply.getParentHeadImg()) && StringUtils.isEmpty((Object)newsReply.getUserNickname()) && StringUtils.isEmpty((Object)newsReply.getHeadImg())) continue;
            waitForUpdateNewsReplyList.add(newsReply);
        }
        MybatisBatchBuilder.create(NewsReplyMapper.class, waitForUpdateNewsReplyList).sessionTemplateName(primarySessionTemplate).run(NewsReplyMapper::updateUserInfo);
        MybatisBatchBuilder.create(UserReplyMapper.class, waitForUpdateNewsReplyList).sessionTemplateName(primarySessionTemplate).run(UserReplyMapper::updateUserInfo);
    }

    @Override
    @Async
    public void syncNewsComment() {
        if (countDownLatch == null || countDownLatch.getCount() == 0L) {
            List idList = this.newsMapper.getNewsIdByIssueTime();
            int tableTotal = 10;
            countDownLatch = new CountDownLatch(tableTotal);
            for (int i = 0; i < tableTotal; ++i) {
                int finalI = i;
                List<Long> filterIdList = idList.stream().filter(x -> x % 10L == (long)finalI).collect(Collectors.toList());
                this.taskExecutor.execute((Runnable)new NewsCommentSyncThread().build(i, filterIdList, countDownLatch));
            }
        }
    }
}

