/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service.impl;

import com.bxm.localnews.service.UserRecommendService;
import com.bxm.localnews.sync.dto.RecommendNativeDTO;
import com.bxm.localnews.sync.service.UserIntegrationService;
import com.bxm.localnews.sync.third.dao.RecommendNativeMapper;
import com.bxm.localnews.sync.vo.business.RecommendNative;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRecommendServiceImpl
implements UserRecommendService {
    private static final Logger log = LoggerFactory.getLogger(UserRecommendServiceImpl.class);
    @Autowired
    private RecommendNativeMapper recommendNativeMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private UserIntegrationService userIntegrationService;

    @Override
    public Boolean updateUserAttribute(RecommendNativeDTO recommendNativeDTO) {
        if (!this.checkInfo(recommendNativeDTO.getUserId())) {
            log.error("\u8be5\u7528\u6237\u975e\u6b63\u5e38\u7528\u6237:{},\u4e0d\u8fdb\u884c\u7528\u6237\u63a8\u8350\u6570\u636e\u6e90\u540c\u6b65", (Object)recommendNativeDTO.getUserId());
            return true;
        }
        RecommendNative recommendNativeEntity = new RecommendNative();
        BeanUtils.copyProperties((Object)recommendNativeDTO, (Object)recommendNativeEntity);
        RecommendNative resultByUserId = this.recommendNativeMapper.selectByUserId(recommendNativeEntity.getUserId());
        if (null == resultByUserId && !this.initUserRecommendInfo(recommendNativeDTO.getUserId())) {
            return true;
        }
        this.recommendNativeMapper.updateAttribute(recommendNativeEntity);
        return true;
    }

    @Override
    public Boolean updateUserBehavior(RecommendNativeDTO recommendNativeDTO) {
        if (!this.checkInfo(recommendNativeDTO.getUserId())) {
            log.error("\u8be5\u7528\u6237\u975e\u6b63\u5e38\u7528\u6237:{},\u4e0d\u8fdb\u884c\u7528\u6237\u63a8\u8350\u6570\u636e\u6e90\u540c\u6b65", (Object)recommendNativeDTO.getUserId());
            return true;
        }
        RecommendNative recommendNativeEntity = new RecommendNative();
        BeanUtils.copyProperties((Object)recommendNativeDTO, (Object)recommendNativeEntity);
        RecommendNative resultByUserId = this.recommendNativeMapper.selectByUserId(recommendNativeEntity.getUserId());
        if (null == resultByUserId && !this.initUserRecommendInfo(recommendNativeDTO.getUserId())) {
            return true;
        }
        this.recommendNativeMapper.updateBehavior(recommendNativeEntity);
        return true;
    }

    @Override
    public Boolean updateUserPosition(RecommendNativeDTO recommendNativeDTO) {
        if (!this.checkInfo(recommendNativeDTO.getUserId())) {
            log.error("\u8be5\u7528\u6237\u975e\u6b63\u5e38\u7528\u6237:{},\u4e0d\u8fdb\u884c\u7528\u6237\u63a8\u8350\u6570\u636e\u6e90\u540c\u6b65", (Object)recommendNativeDTO.getUserId());
            return true;
        }
        RecommendNative recommendNativeEntity = new RecommendNative();
        recommendNativeEntity.setUserId(recommendNativeDTO.getUserId());
        recommendNativeEntity.setLongitude(new BigDecimal(recommendNativeDTO.getLongitude()));
        recommendNativeEntity.setLatitude(new BigDecimal(recommendNativeDTO.getLatitude()));
        recommendNativeEntity.setCurrentAreaCode(recommendNativeDTO.getCurrentAreaCode());
        RecommendNative resultByUserId = this.recommendNativeMapper.selectByUserId(recommendNativeEntity.getUserId());
        if (null == resultByUserId && !this.initUserRecommendInfo(recommendNativeDTO.getUserId())) {
            return true;
        }
        this.recommendNativeMapper.updatePosition(recommendNativeEntity);
        return true;
    }

    private boolean checkInfo(Long userId) {
        return this.userIntegrationService.isNormalUser(userId);
    }

    private boolean initUserRecommendInfo(Long userId) {
        RecommendNative recommendNativeEntity = new RecommendNative();
        recommendNativeEntity.setId(this.sequenceCreater.nextLongId());
        recommendNativeEntity.setUserId(userId);
        recommendNativeEntity.setLongitude(new BigDecimal("116.407526"));
        recommendNativeEntity.setLatitude(new BigDecimal("39.90403"));
        return this.recommendNativeMapper.initUserRecommendInfo(recommendNativeEntity) > 0;
    }
}

