/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.simhash.impl;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.simhash.RepeatCheckService;
import com.bxm.localnews.simhash.utils.Simhash;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RepeatCheckServiceImpl
implements RepeatCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepeatCheckServiceImpl.class);
    private final RedisSetAdapter redisSetAdapter;
    private Set<Long> cacheFingerprintSet;
    private Simhash simhash = new Simhash();
    private int repeatTotal;

    @Autowired
    public RepeatCheckServiceImpl(RedisSetAdapter redisSetAdapter) {
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public boolean repeatNews(Long newsId, String title, String content) {
        long targetFingerprint;
        if (null == this.cacheFingerprintSet) {
            this.reload();
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            content = title + content;
        }
        if (0L == (targetFingerprint = this.simhash.simhash64(content))) {
            LOGGER.info("{}\u7684simhash\u503c\u4e3a0,\u4e0d\u8fdb\u884c\u91cd\u590d\u5224\u65ad", (Object)newsId);
            return true;
        }
        for (Long cacheFingerprint : this.cacheFingerprintSet) {
            if (this.simhash.hammingDistance(cacheFingerprint, targetFingerprint) >= 4) continue;
            ++this.repeatTotal;
            LOGGER.info("{}\u548c{}\u91cd\u590d.\u91cd\u590d\u603b\u6570\uff1a{}", new Object[]{newsId, cacheFingerprint, this.repeatTotal});
            return false;
        }
        this.cacheFingerprintSet.add(targetFingerprint);
        String currentDate = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
        KeyGenerator simhashKey = RedisKey.SPIDER_SIMHASH_CACHE.copy().appendKey((Object)currentDate);
        this.redisSetAdapter.add(simhashKey, new Object[]{targetFingerprint});
        this.redisSetAdapter.expire(simhashKey, DateUtils.addField((Date)new Date(), (int)6, (int)15));
        return true;
    }

    @Override
    public void reload() {
        KeyGenerator[] subKeys = new KeyGenerator[14];
        Date current = new Date();
        String currentDate = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(current);
        KeyGenerator mainKey = RedisKey.SPIDER_SIMHASH_CACHE.copy().appendKey((Object)currentDate);
        for (int i = 1; i <= 14; ++i) {
            String keyPart = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(DateUtils.addField((Date)current, (int)6, (int)(-i)));
            subKeys[i - 1] = RedisKey.SPIDER_SIMHASH_CACHE.copy().appendKey((Object)keyPart);
        }
        this.cacheFingerprintSet = new CopyOnWriteArraySet<Long>();
        this.cacheFingerprintSet.addAll(this.redisSetAdapter.union(mainKey, Long.class, subKeys));
        this.repeatTotal = 0;
    }
}

