/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.simhash.utils;

import com.bxm.localnews.simhash.utils.MurmurHash;
import com.bxm.localnews.sync.service.SegmentIntegrationService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.List;

public class Simhash {
    public int hammingDistance(int hash1, int hash2) {
        int i = hash1 ^ hash2;
        i -= i >>> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >>> 2 & 0x33333333);
        i = i + (i >>> 4) & 0xF0F0F0F;
        i += i >>> 8;
        i += i >>> 16;
        return i & 0x3F;
    }

    public int hammingDistance(long hash1, long hash2) {
        long i = hash1 ^ hash2;
        i -= i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
        i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
        i += i >>> 8;
        i += i >>> 16;
        i += i >>> 32;
        return (int)i & 0x7F;
    }

    private List<String> getTokens(String doc) {
        SegmentIntegrationService segmentIntegrationService = (SegmentIntegrationService)SpringContextHolder.getBean(SegmentIntegrationService.class);
        return segmentIntegrationService.seg(doc);
    }

    public long simhash64(String doc) {
        int i;
        int bitLen = 64;
        int[] bits = new int[bitLen];
        List<String> tokens = this.getTokens(doc);
        for (String t : tokens) {
            long v = MurmurHash.hash64(t);
            for (i = bitLen; i >= 1; --i) {
                if ((v >> bitLen - i & 1L) == 1L) {
                    int n = i - 1;
                    bits[n] = bits[n] + 1;
                    continue;
                }
                int n = i - 1;
                bits[n] = bits[n] - 1;
            }
        }
        long hash = 0L;
        long one = 1L;
        for (i = bitLen; i >= 1; --i) {
            if (bits[i - 1] > 0) {
                hash |= one;
            }
            one <<= 1;
        }
        return hash;
    }

    public long simhash32(String doc) {
        int bitLen = 32;
        int[] bits = new int[bitLen];
        List<String> tokens = this.getTokens(doc);
        for (String t : tokens) {
            int v = MurmurHash.hash32(t);
            for (int i = bitLen; i >= 1; --i) {
                if ((v >> bitLen - i & 1) == 1) {
                    int n = i - 1;
                    bits[n] = bits[n] + 1;
                    continue;
                }
                int n = i - 1;
                bits[n] = bits[n] - 1;
            }
        }
        int hash = 0;
        int one = 1;
        for (int i = bitLen; i >= 1; --i) {
            if (bits[i - 1] > 1) {
                hash |= one;
            }
            one <<= 1;
        }
        return hash;
    }
}

