package com.bxm.localnews.sync.task;

import com.bxm.localnews.service.NewsSyncService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
@DisallowConcurrentExecution
public class SyncNewsPublishJob extends AbstractCustomJob {

    Logger logger = LoggerFactory.getLogger(SyncNewsPublishJob.class);

    @Autowired
    private NewsSyncService newsSyncService;

    public SyncNewsPublishJob() {
        super("SyncNewPublishJob", "0 0/5 * * * ?", "补偿待发布新闻!");
    }

    @Override
    public Message service() {
        logger.info("开始同步待发布新闻！当前时间：{}",new Date());
        newsSyncService.newsPublishSync();
        return Message.build();
    }

}
