package com.bxm.localnews.sync.task;

import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.CountDownLatch;

/**
 * 可以改进，在redis中记录最近发评论的用户，
 */
@Component
@DisallowConcurrentExecution
public class SyncNewsCommentJob extends AbstractCustomJob {

    private static CountDownLatch countDownLatch = null;

    @Resource
    private NewsMapper newsMapper;

    @Resource
    private AsyncTaskExecutor taskExecutor;

    public SyncNewsCommentJob() {
        super("NewsCommentSyncJob", "0 0 5 * * ?", "新闻评论同步");
    }

    @Override
    public Message service() {
//        logger.info("开始同步新闻评论数！当前时间：{}", new Date());
//        if (countDownLatch == null || countDownLatch.getCount() == 0) {
//            List<Long> idList = newsMapper.getNewsIdByIssueTime();
//            /**
//             * 分表总数
//             */
//            int tableTotal = 10;
//            countDownLatch = new CountDownLatch(tableTotal);
//            for (int i = 0; i < tableTotal; i++) {
//                int finalI = i;
//                List<Long> filterIdList;
//                filterIdList = idList.stream().filter(x -> (x % 10) == finalI).collect(Collectors.toList());
//
//                this.taskExecutor.execute(new NewsCommentSyncThread().build(i, filterIdList, countDownLatch));
//            }
//        } else {
//            this.logger.debug("上一次同步工作还没做完" + countDownLatch.getCount());
//        }
        return Message.build();

    }

}
