package com.bxm.localnews.sync.task;


import com.bxm.localnews.sync.primary.dao.NewsKindMapper;
import com.bxm.localnews.sync.primary.dao.NewsPoolMapper;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.CountDownLatch;

@Component
@DisallowConcurrentExecution
public class SyncNewsPoolJob extends AbstractCustomJob {

    private static CountDownLatch countDownLatch = null;

    @Resource
    private AsyncTaskExecutor taskExecutor;

    @Resource
    private NewsKindMapper newsKindMapper;

    @Resource
    private NewsPoolMapper newsPoolMapper;

    public SyncNewsPoolJob() {
        super("syncNewsPool", "0 0 2 * * ?", "新闻缓冲池同步任务");
    }

    @Override
    public Message service() {
//        logger.info("开始同步缓冲池数据！当前时间：{}",new Date());
//        List<NewsKind> kindList = this.newsKindMapper.selectAllKinds();
//
//        //先清除缓冲池中的表数据
//        for (NewsKind newsKind : kindList) {
//            newsPoolMapper.deleteTotal(Long.valueOf(newsKind.getId()));
//        }
//
//        //起多个线程进行缓冲池的填充
//        if (countDownLatch == null || countDownLatch.getCount() == 0) {
//            countDownLatch = new CountDownLatch(kindList.size());
//            for (NewsKind newsKind : kindList) {
//                this.taskExecutor.execute(new NewsPoolSyncThread().build(newsKind.getId(), countDownLatch));
//            }
//        } else {
//            this.logger.debug("上一次同步工作还没做完" + countDownLatch.getCount());
//        }
        return Message.build();
    }
}
