package com.bxm.localnews.sync.task;

import com.bxm.localnews.service.ForumPostService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 由于用户服务出现bug，根据id获取用户信息时没有用户头像或者昵称，导致库里这一部分数据有残缺
 * 在这里进行数据的补录，主要分【评论、帖子点赞、帖子】三部分
 */
@Component
@DisallowConcurrentExecution
public class SyncUserRedundancyInfoJob extends AbstractCustomJob {


    @Autowired
    private ForumPostService forumPostService;

    public SyncUserRedundancyInfoJob() {
        super("SyncUserRedundancyInfoJob", "0 0/50 * * * ?", "用户冗余数据同步任务");
    }

    @Override
    public Message service() {
        logger.info("开始同步用户冗余数据！当前时间：{}",new Date());
        forumPostService.scanningForumPost();
        return Message.build();
    }
}
