package com.bxm.localnews.sync.task;

import com.bxm.localnews.sync.third.dao.UserMapper;
import com.bxm.localnews.sync.thread.UserStatisticSyncThread;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.quartz.DisallowConcurrentExecution;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

@Component
@DisallowConcurrentExecution
public class SyncUserStatisticJob extends AbstractCustomJob {

    @Resource
    private UserMapper userMapper;

    private static CountDownLatch countDownLatch = null;

    @Resource
    private AsyncTaskExecutor taskExecutor;

    /**
     * 分表总数
     */
    private int tableTotal = 10;

    public SyncUserStatisticJob() {
        super("CalculateUserStatisticJob", "0 3 0/1 * * ?", "用户静态数据定期计算");
    }

    @Override
    public Message service() {
        logger.info("开始计算用户静态数据(帖子发布数,评论发布数)!！当前时间：{}",new Date());
        if (countDownLatch == null || countDownLatch.getCount() == 0) {
            List<Long> idList = userMapper.selectUser();
            countDownLatch = new CountDownLatch(this.tableTotal);
            for (int i = 0; i < this.tableTotal; i++) {
                int finalI = i;
                List<Long> filterIdList;
                filterIdList = idList.stream().filter(x -> (x % 10) == finalI).collect(Collectors.toList());

                this.taskExecutor.execute(new UserStatisticSyncThread().build(i,filterIdList, countDownLatch));
            }
        } else {
            this.logger.debug("上一次同步工作还没做完" + countDownLatch.getCount());
        }
        return Message.build();

    }

}
