package com.bxm.localnews.sync.task;

import com.bxm.localnews.service.WechatNewsSyncService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 微信公众号同步任务配置
 * @author zhaoyadong 2018/11/20 15:03
 */
@Component
public class SyncWechatNewsJob extends AbstractCustomJob {

    @Resource
    private WechatNewsSyncService wechatNewsSyncService;

    public SyncWechatNewsJob() {
        super("syncWechatNews", "0 0/15 * * * ?", "微信公众号新闻同步任务");
    }

    @Override
    public Message service() {
        logger.info("开始同步微信公众号新闻数据！当前时间：{}",new Date());
        this.wechatNewsSyncService.sync();
        return Message.build();
    }
}
