/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.RecruitDTO;
import com.bxm.localnews.thirdparty.dto.UserInfoForJobDTO;
import com.bxm.localnews.thirdparty.service.BlueCollarService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"3-09 \u84dd\u9886\u76f8\u5173\u63a5\u53e3"}, description="\u63d0\u4f9b\u84dd\u9886\u76f8\u5173\u63a5\u53e3\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/public/job"})
public class BlueCollarController {
    private UserService userService;
    private BlueCollarService blueCollarService;

    @Autowired
    public BlueCollarController(UserService userService, BlueCollarService blueCollarService) {
        this.userService = userService;
        this.blueCollarService = blueCollarService;
    }

    @ApiOperation(value="3-09-1 \u7528\u6237\u4fe1\u606f\u63a5\u53e3", notes="\u63d0\u4f9b\u7528\u6237\u4fe1\u606f,\u73b0\u9636\u6bb5\u6682\u65e0ip\u76f8\u5173\u6570\u636e\uff0c\u540e\u7eed\u8865\u4e0a")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @GetMapping(value={"/getUserInfo"})
    public Json<UserInfoForJobDTO> getUserInfoByUserId(@RequestParam(value="userId") Long userId) {
        UserInfoForJobDTO userInfoForJobDTO = new UserInfoForJobDTO();
        User user = this.userService.selectByPrimaryKey(userId);
        BeanUtils.copyProperties((Object)user, (Object)userInfoForJobDTO);
        return Json.build((Object)userInfoForJobDTO).setCode(0);
    }

    @ApiOperation(value="3-09-2 \u6839\u636e\u5730\u533a\u7f16\u7801\u83b7\u53d6\u62db\u8058\u5217\u8868", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", paramType="path", dataType="String", required=true)})
    @GetMapping(value={"/getRecruits/{areaCode}"})
    public Json<RecruitDTO> getToolsByCode(@PathVariable String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.blueCollarService.getRecruits(areaCode));
    }
}

