/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.WeatherDTO;
import com.bxm.localnews.thirdparty.service.WeatherService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"3-11 \u5929\u6c14\u67e5\u8be2"}, description="\u5929\u6c14\u67e5\u8be2")
@RestController
@RequestMapping(value={"api/public/weather"})
public class WeatherController {
    private WeatherService weatherService;

    @Autowired
    public WeatherController(WeatherService weatherService) {
        this.weatherService = weatherService;
    }

    @ApiOperation(value="3-11-1 \u6839\u636e\u533a\u57df\u7f16\u7801\u67e5\u8be2\u5929\u6c14", notes="\u533a\u57df\u7f16\u78016\u4f4d")
    @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", paramType="path", dataType="String", required=true)
    @RequestMapping(value={"/{areaCode}"}, method={RequestMethod.GET})
    public Json<WeatherDTO> selectWeather(@PathVariable String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.weatherService.getWeatherByAdcode(areaCode));
    }

    @ApiOperation(value="3-11-2 \u6839\u636e\u533a\u57df\u7f16\u7801\u67e5\u8be2\u5929\u6c14(\u9996\u9875)", notes="\u533a\u57df\u7f16\u78016\u4f4d")
    @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", paramType="path", dataType="String", required=true)
    @RequestMapping(value={"/home/{areaCode}"}, method={RequestMethod.GET})
    public Json<WeatherDTO> selectHomeWeather(@PathVariable String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.weatherService.getHomeWeatherByAdcode(areaCode));
    }
}

