package com.bxm.localnews.thirdparty.controller;

import java.util.List;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.service.AdvertService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by hsq 17:37 2018/5/23
 */
@Api(tags = "3-01 广告接口", description = "广告接口相关操作")
@RestController
@RequestMapping("api/public/advert")
public class AdvertController {

    private AdvertService advertService;

    @Autowired
    public AdvertController(AdvertService advertService) {
        this.advertService = advertService;
    }

    @ApiOperation(value = "3-01-1 根据类型获取广告", notes = "type广告类型 1:首页弹窗广告 2:日常任务广告 7:开屏广告 3：轮播广告 " +
            "4：个人中心轮播广告")
    //1：首页弹窗广告 2：个人中心随机广告  3：赚钱中心轮播广告 4：列表广告 5：赚钱中心公告 6：首页悬浮广告
    //1,2,3,4,5,6,
    @ApiImplicitParams({
            @ApiImplicitParam(name = "type", value = "广告类型", allowableValues = "1,2,3,4,7", dataType = "String", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "userId", value = "用户id", paramType = "query", dataType = "String")
    })

    @GetMapping("/type")
    public Json<List<AdvertDTO>> getAdvertsByType(@RequestParam String type,
                                                  @RequestParam(required = false) String areaCode,
                                                  @RequestParam(required = false) Long userId) {
        return ResultUtil.genSuccessResult(this.advertService.queryAdByType(Byte.valueOf(type), areaCode, userId));
    }
}
