package com.bxm.localnews.thirdparty.controller;

import java.util.List;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.WeatherDTO;
import com.bxm.localnews.thirdparty.dto.WeatherExtendDTO;
import com.bxm.localnews.thirdparty.service.WeatherService;

import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2018/10/17 18:55
 * @desc
 */
@Api(tags = "3-11 天气查询", description = "天气查询")
@RestController
@RequestMapping("api/public/weather")
public class WeatherController extends BaseController {

    private WeatherService weatherService;

    @Autowired
    public WeatherController(WeatherService weatherService) {
        this.weatherService = weatherService;
    }

    @ApiOperation(value = "3-11-1 根据区域编码查询天气", notes = "区域编码6位")
    @ApiImplicitParam(name = "areaCode", value = "地区编码", paramType = "path", dataType = "String", required = true)
    @RequestMapping(value = "/{areaCode}", method = RequestMethod.GET)
    public Json<WeatherDTO> selectWeather(@PathVariable String areaCode) throws Exception {
        areaCode = replaceAreaCode(areaCode);
        return ResultUtil.genSuccessResult(this.weatherService.getWeatherByAdcode(areaCode));
    }

    @ApiOperation(value = "3-11-2 根据区域编码查询天气(首页)", notes = "区域编码6位")
    @ApiImplicitParam(name = "areaCode", value = "地区编码", paramType = "path", dataType = "String", required = true)
    @RequestMapping(value = "/home/{areaCode}", method = RequestMethod.GET)
    public Json<WeatherDTO> selectHomeWeather(@PathVariable String areaCode) throws Exception {
        areaCode = replaceAreaCode(areaCode);
        return ResultUtil.genSuccessResult(this.weatherService.getHomeWeatherByAdcode(areaCode));
    }

    @ApiOperation(value = "3-11-3 根据区域编码查询未来7天天气列表", notes = "")
    @ApiImplicitParam(name = "areaCode", value = "地区编码", paramType = "query", dataType = "String", required = true)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public Json<List<WeatherExtendDTO>> selectWeatherList(String areaCode) throws Exception {
        areaCode = replaceAreaCode(areaCode);
        return ResultUtil.genSuccessResult(this.weatherService.getFutureWeather(areaCode));
    }

    /**
     * 地区编码获取前6位
     *
     * @param areaCode
     * @return
     */
    private String replaceAreaCode(String areaCode) throws Exception {
        direct().prop("areaCode", areaCode).notBlank("地区编码不能为空").max(12, "最大长度为12");
        return areaCode.substring(0, 6);
    }
}
