package com.bxm.localnews.thirdparty.wxmessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.*;

public class UploadImg {

    private static Logger LOG = LoggerFactory.getLogger(UploadImg.class);

    public static void main(String[] args) {
        String url = "https://api.weixin.qq.com/cgi-bin/media/upload";
        Map<String, String> params = new HashMap<>();
        params.put("access_token",
                   "18_wz2Xok6H3FNuFaFxBasfCQ8JBynFY1y7wXgapqDQUIkrDZiAJmvWHQVGQUo8g73OUFmugDqCT8HAjD4zv0TtQrRMejEd97G7fCytrR4KO4ZupIlLtgSje0S2ZSRrkBt-9ePgrpBJvWCMu9xxRHNdADAZPV");
        params.put("type", "image");
        JSONObject result = httpPost(url,
                                     new File("C:\\Users\\Administrator\\Desktop\\万事通客服微信\\备用\\微信号负责人及话术及二维码\\fuyang2.png"),
                                     params);
        System.out.println(result.get("media_id"));
        System.out.println(result.toJSONString());

    }

    public static String uploadImg(String token, File file) {
        String url = "https://api.weixin.qq.com/cgi-bin/media/upload";
        Map<String, String> params = new HashMap<>();
        params.put("access_token", token);
        params.put("type", "image");
        JSONObject result = httpPost(url, file, params);
        if (result.get("media_id") != null) {
            return result.getString("media_id");
        }
        LOG.warn("上传微信客服素材图 url result:{}", JSON.toJSONString(result));
        return null;

    }

    public static JSONObject httpPost(String url, File file, Map<String, String> queryParams) {
        JSONObject context = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        if (queryParams != null) {
            url = connectUrlAndParams(url, queryParams);
        }
        HttpPost httpPost = new HttpPost(url);
        if (file.exists()) {
            FileBody fileBody = new FileBody(file);
            HttpEntity entity = MultipartEntityBuilder.create().addPart("media", fileBody).build();
            httpPost.setEntity(entity);
        }
        try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                context = getResponseContext(response);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return context;
    }

    /**
     * 把response中的实体内容转换成json
     *
     * @param response
     * @return
     */
    private static JSONObject getResponseContext(CloseableHttpResponse response) {
        StringBuilder context = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));) {
            String line = null;
            while ((line = reader.readLine()) != null) {
                context.append(line);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return JSONObject.parseObject(context.toString());
    }

    /**
     * 把url和params用?和&拼接起来，比如xxx.xxx.com?a=1&b=2
     *
     * @param url
     * @param params
     * @return
     */
    private static String connectUrlAndParams(String url, Map<String, String> params) {
        Set<Map.Entry<String, String>> entries = params.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entries.iterator();
        List<String> paramsList = new ArrayList<>(entries.size());
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String) entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append((String) entry.getValue());
            paramsList.add(stringBuilder.toString());
            i++;
        }
        String paramsStr = join(paramsList, "&");
        StringBuilder stringBuilder = new StringBuilder(url);
        stringBuilder.append("?");
        stringBuilder.append(paramsStr);

        return stringBuilder.toString();
    }

    /**
     * 把集合拼接成字符串
     * 
     * @param var0
     * @param var1
     * @return
     */
    private static String join(Collection var0, String var1) {
        StringBuffer var2 = new StringBuffer();

        for (Iterator var3 = var0.iterator(); var3.hasNext(); var2.append((String) var3.next())) {
            if (var2.length() != 0) {
                var2.append(var1);
            }
        }

        return var2.toString();
    }
}
