package com.bxm.localnews.thirdparty.constant;

/**
 * Created by Administrator on 2018/3/29.
 */
public enum AdvertTypeEnum {

    INDEX_POP_WINDOW(1,"首页弹窗广告"),
    DAILY_TASK(2, "日常任务广告"),
    TURN_AROUND_ADVERT(3,"轮播广告"),
    TURN_AROUND_PERSONAL_CENTER(4,"个人中心轮播广告"),
    START_SCREEN(7,"开屏广告"),
    INDEX_CONFIG(8,"首页配置广告"),
    TURN_AROUND_SIGN_IN(9,"签到中心轮播广告"),
    TURN_AROUND_MESSAGE_CENTER(10,"消息中心轮播广告"),
    COMMUNITY_INDEX_CONTENT(11,"社区首页广告"),
    IOS_RED_PACKET(12, "IOS红包墙广告位"),
    MINI_PROGRAM_INDEX_BANNER(13, "小程序首页banner"),
    MINI_PROGRAM_SUSPEND(14,"小程序悬浮广告"),
    MINI_PROGRAM_POP_WINDOW(15,"小程序首页弹窗广告"),
    PUBLISH_SUC_BOTTOM(16,"发布成功底部广告位"),
    CONVENIENCE_CENTER(17,"便民中心广告位"),
    OST_SHARE_SUSPEND(18,"帖子分享页悬浮广告"),
    NEWS_SHARE_SUSPEND(19,"新闻分享页悬浮广告"),
    POST_SHARE_BANNER(20,"帖子分享页banner广告"),
    NEWS_SHARE_BANNER(21,"新闻分享页banner广告"),
    PUBLISH_SUSPEND(22,"发布成功悬浮广告"),
    NEWS_DETAIL_BANNER(23,"新闻内容详情广告位"),
    POST_DETAIL_BANNER(24,"帖子内容详情广告位"),
    IP_PAGE_BALL_ADVERT(25,"vip页面球区广告"),
    VIP_PAGE_TOP_BANNER(26,"VIP页面顶部banner"),
    VIP_PAGE_MERCHANT(27,"vip页面特惠商家广告位"),
    MERCHANT_PAGE_TOP_BANNER(28,"特惠商家列表顶部banner广告位"),
    VIP_CARD_PAGE_ZJTQ(29,"已开卡权益页面-最近特权"),
    VIP_CARD_PAGE_RMTQ(30,"已开卡权益页面-热门特权"),
    VIP_CARD_PAGE_YYWL(31,"已开卡权益页面-影音娱乐"),
    VIP_CARD_PAGE_MSCY(32,"已开卡权益页面-美食餐饮"),
    VIP_CARD_PAGE_FLSC(33,"已开卡权益页面-返利商场"),
    VIP_CARD_PAGE_DPFL(34,"已开卡权益页面-大牌返利"),
    VIP_CARD_PAGE_CSGW(35,"已开卡权益页面-超时购物"),
    VIP_CARD_PAGE_LLCX(36,"已开卡权益页面-旅游出行"),
    VIP_CARD_PAGE_DSXX(37,"已开卡权益页面-读书学习"),
    VIP_CARD_PAGE_SHFW(38,"已开卡权益页面-生活服务"),
    VIP_CARD_PAGE_CZFW(39,"已开卡权益页面-车主福利"),
    VIP_CARD_PAGE_YHJK(40,"已开卡权益页面-医护健康"),
    VIP_CARD_PAGE_MFZQ(41,"已开卡权益页面-免费专区");

    private int type;

    private String desc;

    AdvertTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static AdvertTypeEnum getByPosition(int position) {
        AdvertTypeEnum[] postions = AdvertTypeEnum.values();

        for (AdvertTypeEnum positionType : postions) {
            if (position == positionType.getType()) {
                return positionType;
            }
        }

        return null;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
