package com.bxm.localnews.thirdparty.constant;

/**
 * @author zhaoyadong 2018/10/19 15:37
 * @desc
 */
public enum WeatherEnum {
    /**
     * 天气
     **/
    CLEAR("晴", new String[]{"晴", "热"}, "https://m.wstong.com/localnews_prod/weather/clear.png", "https://m.wstong.com/localnews_prod/weather/home_clear.png"),
    Cloudy("多云", new String[]{"多云", "少云", "晴间多云"}, "https://m.wstong.com/localnews_prod/weather/cloudy.png", "https://m.wstong.com/localnews_prod/weather/home_cloudy.png"),
    SHADE("阴", new String[]{"阴", "有风", "平静", "微风", "和风", "清风", "强风/劲风", "疾风", "大风", "烈风"}, "https://m.wstong.com/localnews_prod/weather/shade.png", "https://m.wstong.com/localnews_prod/weather/home_shade.png"),
    SHOWER("阵雨", new String[]{"阵雨"}, "https://m.wstong.com/localnews_prod/weather/shower.png", "https://m.wstong.com/localnews_prod/weather/home_shower.png"),
    THUNDER_SHOWER("雷阵雨", new String[]{"雷阵雨", "雷阵雨并伴有冰雹", "强阵雨"}, "https://m.wstong.com/localnews_prod/weather/thunder_shower.png", "https://m.wstong.com/localnews_prod/weather/home_thunder_shower.png"),
    LIGHT_RAIN("小雨", new String[]{"小雨", "毛毛雨/细雨", "雨", "冷"}, "https://m.wstong.com/localnews_prod/weather/light_rain.png", "https://m.wstong.com/localnews_prod/weather/home_light_rain.png"),
    MODERATE_RAIN("中雨", new String[]{"中雨", "小雨-中雨", "小到中雨"}, "https://m.wstong.com/localnews_prod/weather/moderate_rain.png", "https://m.wstong.com/localnews_prod/weather/home_moderate_rain.png"),
    HEAVY_RAIN("大雨", new String[]{"大雨", "中雨-大雨", "极端降雨", "中到大雨"}, "https://m.wstong.com/localnews_prod/weather/heavy_rain.png", "https://m.wstong.com/localnews_prod/weather/home_heavy_rain.png"),
    STORM_RAIN("暴雨", new String[]{"暴雨", "大暴雨", "特大暴雨", "大到暴雨", "大雨-暴雨", "暴雨-大暴雨", "大暴雨-特大暴雨", "暴雨到大暴雨", "大暴雨到特大暴雨"}, "https://m.wstong.com/localnews_prod/weather/storm_rain.png", "https://m.wstong.com/localnews_prod/weather/home_storm_rain.png"),
    FREEZING_RAIN("冻雨", new String[]{"冻雨"}, "https://m.wstong.com/localnews_prod/weather/freezing_rain.png", "https://m.wstong.com/localnews_prod/weather/home_freezing_rain.png"),
    SLEET("雨夹雪", new String[]{"雨夹雪", "雨雪天气", "阵雨夹雪"}, "https://m.wstong.com/localnews_prod/weather/sleet.png", "https://m.wstong.com/localnews_prod/weather/home_sleet.png"),
    SNOW_SHOWER("阵雪", new String[]{"阵雪"}, "https://m.wstong.com/localnews_prod/weather/snow_shower.png", "https://m.wstong.com/localnews_prod/weather/home_snow_shower.png"),
    LIGHT_SNOW("小雪", new String[]{"小雪", "弱高吹雪", "雪"}, "https://m.wstong.com/localnews_prod/weather/light_snow.png", "https://m.wstong.com/localnews_prod/weather/home_light_snow.png"),
    MODERATE_SNOW("中雪", new String[]{"中雪", "小雪-中雪", "小到中雪"}, "https://m.wstong.com/localnews_prod/weather/moderate_snow.png", "https://m.wstong.com/localnews_prod/weather/home_moderate_snow.png"),
    HEAVY_SNOW("大雪", new String[]{"大雪", "中雪-大雪", "中到大雪"}, "https://m.wstong.com/localnews_prod/weather/heavy_snow.png", "https://m.wstong.com/localnews_prod/weather/home_heavy_snow.png"),
    STORM_SNOW("暴雪", new String[]{"暴雪", "大雪-暴雪", "大到暴雪"}, "https://m.wstong.com/localnews_prod/weather/storm_snow.png", "https://m.wstong.com/localnews_prod/weather/home_storm_snow.png"),
    FOG("雾", new String[]{"雾", "薄雾", "浓雾", "强浓雾", "大雾", "特强浓雾"}, "https://m.wstong.com/localnews_prod/weather/fog.png", "https://m.wstong.com/localnews_prod/weather/home_fog.png"),
    SAND_STORM("沙尘暴", new String[]{"沙尘暴", "强沙尘暴"}, "https://m.wstong.com/localnews_prod/weather/sand_storm.png", "https://m.wstong.com/localnews_prod/weather/home_sand_storm.png"),
    FLOATING_DUST("浮尘", new String[]{"浮尘"}, "https://m.wstong.com/localnews_prod/weather/floating_dust.png", "https://m.wstong.com/localnews_prod/weather/home_floating_dust.png"),
    BLOWING_SAND("扬沙", new String[]{"扬沙"}, "https://m.wstong.com/localnews_prod/weather/blowing_sand.png", "https://m.wstong.com/localnews_prod/weather/home_blowing_sand.png"),
    SQUALL("飑", new String[]{"飑", "风暴", "飓风", "热带风暴"}, "https://m.wstong.com/localnews_prod/weather/squall.png", "https://m.wstong.com/localnews_prod/weather/home_squall.png"),
    TORNADO("龙卷风", new String[]{"龙卷风"}, "https://m.wstong.com/localnews_prod/weather/tornado.png", "https://m.wstong.com/localnews_prod/weather/home_tornado.png"),
    HAZE("霾", new String[]{"霾", "轻霾", "中度霾", "重度霾", "严重霾"}, "https://m.wstong.com/localnews_prod/weather/haze.png", "https://m.wstong.com/localnews_prod/weather/home_haze.png"),
    HAIl("冰雹", new String[]{"冰雹"}, "https://m.wstong.com/localnews_prod/weather/hail.png", "https://m.wstong.com/localnews_prod/weather/home_hail.png");

    private String name;

    private String[] tags;

    /**
     * 广场天气图标
     */
    private String img;

    /**
     * 首页天气图标
     */
    private String homeImg;

    WeatherEnum(String name, String[] tags, String img, String homeImg) {
        this.name = name;
        this.tags = tags;
        this.img = img;
        this.homeImg = homeImg;
    }

    public static WeatherEnum getWeatherEnum(String name) {
        for (WeatherEnum weatherEnum : WeatherEnum.values()) {
            for (String str : weatherEnum.getTags()
                    ) {
                if (str.equals(name)) {
                    return weatherEnum;
                }
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getTags() {
        return tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public String getHomeImg() {
        return homeImg;
    }

    public void setHomeImg(String homeImg) {
        this.homeImg = homeImg;
    }
}
