package com.bxm.localnews.thirdparty.service;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.dto.ClassificationDTO;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.AdvertParam;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.vo.Advert;
import com.bxm.localnews.thirdparty.vo.AdvertVO;

import java.util.List;

/**
 * Created by hsq 10:32 2018/2/8
 */
public interface AdvertService {

    /**
     * 广告列表
     *
     * @param type     类型
     * @param areaCode 地区编码
     * @param userId   用户id
     * @return 对应类型的广告列表
     */
    @Deprecated
    List<AdvertVO> queryAdByType(Byte type, String areaCode, Long userId, BasicParam basicParam);

    /**
     * 广告列表
     * @param param 请求广告参数
     * @return  对应类型的广告列表
     */
    List<AdvertVO> queryAdByType(AdvertisementParam param);

    /**
     * 广告列表
     * @param param 请求广告参数
     * @return  对应类型的广告列表
     */
    List<AdvertVO> queryAdByTypeIds(AdvertisementParam param);


    /**
     * 广告
     *
     * @param id
     * @return
     */
    Advert selectByPrimaryKey(Long id);

    /**
     * 广告列表
     *
     * @param size 长度
     * @return 固定长度的广告列表
     */
    List<AdvertDTO> getListAds(int size);

    /**
     * 获取首页弹窗(已废弃，该方法已重构，{@link PopService})
     *
     * @param homeWindowParam
     * @param ip
     * @return
     */
    @Deprecated
    HomeWindowDTO getHomeWindow(HomeWindowParam homeWindowParam, String ip);


    /**
     * vip开卡权益页面广告位合集
     * @param param
     * @return
     */
    List<ClassificationDTO> vipPageClassificationList(AdvertParam param);

    /**
     * 获取广告素材素材信息
     * @param id ： 素材id
     * @return
     */
    AdvertVO getByMateriaId(Long id);
}
