package com.bxm.localnews.thirdparty.service;

import com.bxm.localnews.thirdparty.dto.WxUserInfo;

/**
 * @author zhaoyadong 2019/5/6 14:01
 * @desc
 */
public interface WxMpFacadeService {

    /**
     * 获取微信accessToken
     *
     * @return
     */
    String getAccessToken();

    /**
     * 判断是否关注微信公众号
     *
     * @param openId
     * @return 关注微信公众号成功返回true,否则返回false
     */
    Boolean subscribeWechat(String openId);

    /**
     * 根据微信授权码获取微信用户信息
     * @param authCode 微信授权码（前端申请授权后获取）
     * @param type 获取类型（从哪个公众号获取）
     * @return 微信用户信息
     */
    WxUserInfo getWxUserInfoByCode(String authCode,String type);
}
