package com.bxm.localnews.thirdparty.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("积分商城返回的基础信息")
public class PointStoreBaseDTO {

    @ApiModelProperty(value = "返回状态值：ok或者fail")
    private String status;

    @ApiModelProperty("返回信息")
    private String errorMessage;

    protected PointStoreBaseDTO() {
    }

    protected PointStoreBaseDTO(String status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static PointStoreBaseDTO success(){
        return new PointStoreBaseDTO("ok", "");
    }

    public static PointStoreBaseDTO fail(String message){
        return new PointStoreBaseDTO("fail", message);
    }
}
