package com.bxm.localnews.thirdparty.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("用户积分信息")
public class UserPointDTO extends PointStoreBaseDTO {

    @ApiModelProperty("积分")
    private String point;

    protected UserPointDTO(){
        super("ok", "");
    }

    protected UserPointDTO(String point) {
        super("ok", "");
        this.point = point;
    }

    protected UserPointDTO(String status, String errorMessage){
        super(status, errorMessage);
    }

    protected UserPointDTO(String status, String errorMessage, String point) {
        super(status, errorMessage);
        this.point = point;
    }

    public String getPoint() {
        return point;
    }

    public void setPoint(String point) {
        this.point = point;
    }

    public static UserPointDTO success(String point){
        return new UserPointDTO(point);
    }

    public static UserPointDTO fail(String message){
        return new UserPointDTO("fail", message);
    }

}
