package com.bxm.localnews.thirdparty.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "广告")
public class AdvertDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("广告跳转地址")
    private String address;

    @ApiModelProperty(" 缩略图 ")
    private String imgUrl;

    @ApiModelProperty("广告名称")
    private String title;

    @ApiModelProperty("开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("广告倒计时时间（广告倒计时结束后自动关闭）")
    private Byte timeout;

    @ApiModelProperty("展示方式：0默认展示，1新用户展示一次，2所有用户只展示1次，3每天第一次打开App时展示")
    private Byte showType;

    @ApiModelProperty("任务主标题")
    private String taskMaintitle;

    @ApiModelProperty("任务副标题")
    private String taskSubtitle;

    @ApiModelProperty("文案")
    private String copy;

    @ApiModelProperty("素材内容")
    private String materialContent;

    @ApiModelProperty("按钮地址")
    private String iconUrl;

    @ApiModelProperty("素材id")
    private Long materialId;

    @ApiModelProperty("广告投放对象")
    private String deliveryObject;

    public String getDeliveryObject() {
        return deliveryObject;
    }

    public void setDeliveryObject(String deliveryObject) {
        this.deliveryObject = deliveryObject;
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Byte getTimeout() {
        return timeout;
    }

    public void setTimeout(Byte timeout) {
        this.timeout = timeout;
    }

    public Byte getShowType() {
        return showType;
    }

    public void setShowType(Byte showType) {
        this.showType = showType;
    }

    public String getTaskMaintitle() {
        return taskMaintitle;
    }

    public void setTaskMaintitle(String taskMaintitle) {
        this.taskMaintitle = taskMaintitle;
    }

    public String getTaskSubtitle() {
        return taskSubtitle;
    }

    public void setTaskSubtitle(String taskSubtitle) {
        this.taskSubtitle = taskSubtitle;
    }

    public String getCopy() {
        return copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public String getMaterialContent() {
        return materialContent;
    }

    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
}
