package com.bxm.localnews.thirdparty.dto;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/5/24 14:05
 * @desc
 */
public class WxMaUserData {

    @ApiModelProperty(value = "appid:可由前端传入")
    private String appId;

    @ApiModelProperty(value = "加密数据", required = true)
    private String encryptedData;

    @ApiModelProperty(value = "会话key", required = true)
    private String sessionKey;

    @ApiModelProperty(value = "iv", required = true)
    private String iv;

    @ApiModelProperty(value = "邀请人ID", required = false)
    private Long inviteUserId;

    @ApiModelProperty(value = "是否来自于任务列表邀请", required = false)
    private Boolean taskInvited = false;

    @ApiModelProperty(value = "平台信息 1：安卓 2：IOS 3：web 4:draw, 5:wst_applet", allowableValues = "1,2,3,4,5", required = true)
    private String platform;

    @ApiModelProperty(value = "小程序类型, 默认是小程序转盘", example = "APPLET_DRAW, APPLET_WST")
    private String type = "APPlET_DRAW";

    @ApiModelProperty("地区信息")
    private String area;

    @ApiModelProperty(hidden = true)
    private String ip;

    @ApiModelProperty("注册关联id")
    private Long relationId;

    public Boolean getTaskInvited() {
        return taskInvited;
    }

    public void setTaskInvited(Boolean taskInvited) {
        this.taskInvited = taskInvited;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getEncryptedData() {
        return encryptedData;
    }

    public void setEncryptedData(String encryptedData) {
        this.encryptedData = encryptedData;
    }

    public String getSessionKey() {
        return sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public String getIv() {
        return iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public Long getInviteUserId() {
        return inviteUserId;
    }

    public void setInviteUserId(Long inviteUserId) {
        this.inviteUserId = inviteUserId;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }
}
