package com.bxm.localnews.thirdparty.constant;

import java.util.Optional;

/**
 * order tab 跳转类型
 * @author Gonzo
 * @date  2020-07-15 10:27
 * @since 3.4.0
 */
public enum OrderJumpType {
    /**
     * 淘客订单
     */
    TAOKE_ORDER((byte) 1),
    /**
     * 加油宝
     */
    OIL_ORDER((byte) 2),
    /**
     * 卡券中心
     */
    COUPON_ORDER((byte) 3),

    /**
     * 千猪肯德基订单页
     */
    QIANZHU_KFC_ORDER((byte) 4),
    /**
     * 千猪肯德基首页
     */
    QIANZHU_KFC_HOMEPAGE((byte) 5),
    ;

    private byte jumpType;

    OrderJumpType(byte jumpType) {
        this.jumpType = jumpType;
    }

    public byte getJumpType() {
        return jumpType;
    }

    public static Optional<OrderJumpType> typeValueOf(byte type) {
        for (OrderJumpType value : OrderJumpType.values()) {
            if (value.jumpType == type) {
                return Optional.of(value);
            }
        }

        return Optional.empty();
    }
}

