package com.bxm.localnews.thirdparty.dto;

import com.bxm.localnews.common.dto.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "广告")
@Data
public class AdvertDTO extends BaseDTO {

    @ApiModelProperty("广告跳转地址")
    private String address;

    @ApiModelProperty(" 缩略图 ")
    private String imgUrl;

    @ApiModelProperty("广告名称")
    private String title;

    @ApiModelProperty("开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("广告倒计时时间（广告倒计时结束后自动关闭）")
    private Byte timeout;

    @ApiModelProperty("展示方式：0默认展示，1新用户展示一次，2所有用户只展示1次，3每天第一次打开App时展示")
    private Byte showType;

    @ApiModelProperty("[任务]主标题")
    private String taskMaintitle;

    @ApiModelProperty("[任务]副标题")
    private String taskSubtitle;

    @ApiModelProperty("[任务]文案")
    private String copy;

    @ApiModelProperty("素材内容")
    private String materialContent;

    @ApiModelProperty("按钮地址")
    private String iconUrl;

    @ApiModelProperty("素材id")
    private Long materialId;

    @ApiModelProperty("素材类型，1-文字，2-图片，3-任务素材，4：小程序客服，5：小程序分享")
    private Byte materialType;

    @ApiModelProperty("广告投放对象")
    private String deliveryObject;

    @ApiModelProperty("广告素材名称")
    private String name;

    /******************************以下为3.2.0版本新增*********************/

    @ApiModelProperty("图片素材副标题")
    private String imgSubtitle;

    @ApiModelProperty("图片素材时-弹窗大图")
    private String popImgUrl;

    @ApiModelProperty("图片素材时 -弹窗 文案")
    private String popContent;

    @ApiModelProperty("图片素材时 -弹窗 按钮文案")
    private String popButtonText;

    @ApiModelProperty("图片素材时 -弹窗 按钮跳链地址")
    private String popButtonLinkUrl;

    @ApiModelProperty("前置条件 1-vip 多个条件的组合  (多个前置条件都逗号隔开)")
    private String preconditions;

    @ApiModelProperty("是否配置弹窗 0-不需要  1-需要")
    private Integer needPop;

    @ApiModelProperty("后续动作选项，0-无" +
            "1-打开商品" +
            "2-跳转链接" +
            "3-跳转联盟官方活动" +
            "4-跳转搜索" +
            "5-跳转千猪肯德基点餐" +
            "6-跳转到第三方广告" +
            "7-跳转我的收益"+
            "8-跳转0元购"+
            "9-跳转红花夺宝"+
            "10-跳转商品活动"
    )
    private Integer followAct;

    @ApiModelProperty("后续动作的内容 当follow_act为1时则为商品id,2时为链接地址，3为活动id")
    private String followContent;

    @ApiModelProperty("follow_act为3时的联盟推广位id")
    private String adzoneId;

    /******************************以下为3.3.1版本新增*********************/

    @ApiModelProperty("图片素材-头像地址")
    private String headImg;

    @ApiModelProperty("是否热词 0 否   1 是")
    private Integer hotWords;

    @ApiModelProperty("0 : 无  1-左文右小图 ; 2-上文下三图 ; 3-上文下大图")
    private Integer advertStyle;

    @ApiModelProperty("当前广告位下的具体业务id 如：栏目id、便民子栏目id等等")
    private Long positionBizId;

    @ApiModelProperty("投放人群 0 全部人群 1 淘客新人 2 非淘客新人 3 新用户 4 老用户 5 vip 6 非vip")
    private Byte deliveryCrowd;
}
