package com.bxm.localnews.thirdparty.dto;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2018/10/17 18:59
 * @desc
 */
@ApiModel(description = "天气")
public class WeatherDTO {

    @ApiModelProperty("省份名")
    private String province = "";

    @ApiModelProperty("城市名")
    private String city = "";

    @ApiModelProperty("区域编码")
    private String adcode = "";

    @ApiModelProperty("天气现象")
    private String weather = "——";

    @ApiModelProperty("天气图标")
    private String weatherImg = "";

    @ApiModelProperty("实时气温，单位：摄氏度")
    private String temperature = "-";

    @ApiModelProperty("风向描述")
    private String winddirection = "-";

    @ApiModelProperty("风力级别，单位：级")
    private String windpower = "-";

    @ApiModelProperty("空气湿度")
    private String humidity = "-";

    @ApiModelProperty("数据发布的时间")
    private String reporttime = new Date().toString();

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getAdcode() {
        return adcode;
    }

    public void setAdcode(String adcode) {
        this.adcode = adcode;
    }

    public String getWeather() {
        return weather;
    }

    public void setWeather(String weather) {
        this.weather = weather;
    }

    public String getWeatherImg() {
        return weatherImg;
    }

    public void setWeatherImg(String weatherImg) {
        this.weatherImg = weatherImg;
    }

    public String getTemperature() {
        return temperature;
    }

    public void setTemperature(String temperature) {
        this.temperature = temperature;
    }

    public String getWinddirection() {
        return winddirection;
    }

    public void setWinddirection(String winddirection) {
        this.winddirection = winddirection;
    }

    public String getWindpower() {
        return windpower;
    }

    public void setWindpower(String windpower) {
        this.windpower = windpower;
    }

    public String getHumidity() {
        return humidity;
    }

    public void setHumidity(String humidity) {
        this.humidity = humidity;
    }

    public String getReporttime() {
        return reporttime;
    }

    public void setReporttime(String reporttime) {
        this.reporttime = reporttime;
    }
}
