package com.bxm.localnews.thirdparty.param;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("广告查询")
public class AdvertisementApiParam extends BasicParam {

    @ApiModelProperty("广告类型" +
            "1:首页弹窗广告 " +
            "2:日常任务广告 " +
            "3：轮播广告 " +
            "4：个人中心轮播广告 " +
            "7:开屏广告 " +
            "8:首页配置广告 " +
            "9:签到页面轮播广告 " +
            "10:消息中心轮播广告 " +
            "11:社区首页文字广告" +
            "12:IOS红包墙广告位," +
            "13:小程序首页" +
            "14:小程序悬浮广告" +
            "15:小程序首页弹窗广告" +
            "16:发布成功底部广告位" +
            "17:便民中心广告位" +
            "18:帖子分享页悬浮广告," +
            "19:新闻分享页悬浮广告" +
            "20:帖子分享页banner广告" +
            "21:新闻分享页banner广告" +
            "22:发布成功悬浮广告" +
            "23:新闻内容详情广告位," +
            "24:帖子内容详情广告位" +
            "25：vip页面球区 " +
            "26：vip页面banner  " +
            "27:vip页面特惠广告  " +
            "28：特惠商家列表页面banner " +
            "29: 已开卡权益页面-最近特权  " +
            "30: 已开卡权益页面-热门特权   " +
            "31: 已开卡权益页面-影音娱乐  " +
            "32：已开卡权益页面-美食餐饮 " +
            "33：已开卡权益页面-返利商场 " +
            "34：已开卡权益页面-大牌返利   " +
            "35：已开卡权益页面-超时购物  " +
            "36：已开卡权益页面-旅游出行  " +
            "37：已开卡权益页面-读书学习  " +
            "38：已开卡权益页面-生活服务  " +
            "39：已开卡权益页面-车主福利  " +
            "40：已开卡权益页面-医护健康  " +
            "41：已开卡权益页面-免费专区  " +
            "42：活动模板banner   " +
            "43: vip资源位广告" +
            "44-头条信息流广告位【first】 " +
            "45-头条信息流广告位【second】 " +
            "46-头条信息流广告位【third】 " +
            "47-本地圈广告【first】 " +
            "48-本地圈广告【second】 " +
            "49-搜索框位" +
            "50-热搜位 " +
            "51-收徒海报 " +
            "52-栏目话题页面banner " +
            "53-栏目话题页面球区广告位 " +
            "54-便民栏目banner " +
            "55-便民子栏目banner " +
            "56-商家中心 " +
            "57-邀请码激活海报" +
            "58 VIP滚动公告" +
            "59 VIP热门优惠" +
            "60 首页球区广告位" +
            "61 首页右下角悬浮广告位 " +
            "62 邀请好友分享广告位" +
            "63 站外帖子顶部下载区域" +
            "64 我的模块顶部icon" +
            "65 商家中心轮播消息广告位"+
            "66 头条橱窗"+
            "67 签到页banner " +
            "68 万事通下载页（夺宝素材）")

    private Byte type;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("用户id")
    private Long userId;

    @Deprecated
    @ApiModelProperty("广告投放id，使用英文逗号分隔，当同一个广告类型在不同的业务场景下使用时需要传递 3.4.0版本开始不再新增 新功能使用positionBizId")
    private String ids;

    @ApiModelProperty(value = "业务id （栏目id、商家分类id）同一个广告位在不同的分类下展示不同的广告时需要传递", required = false)
    private Long positionBizId;

}
