package com.bxm.localnews.thirdparty.param;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author gonzo
 * @date 2020-08-21 14:19
 **/
@Data
@ApiModel("引导弹窗的开启状态")
public class GuideStatusParam extends BasicParam {

    @ApiModelProperty(value = "用户id" , required = true)
    private Long userId;

    @ApiModelProperty(value = "引导弹窗类型" +
            "10017-主页栏目引导弹窗" +
            "10018-本地圈引导弹窗" +
            "10019-+号发帖按钮引导弹窗" +
            "10020-我的页面邀请好友的引导弹窗", required = true)
    private Integer type;

    @ApiModelProperty(value = "城市编码" , required = true)
    private String areaCode;

}
