package com.bxm.localnews.thirdparty.param.bxm.advertisement.req;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("SSP app 信息")
public class AppReq {

    /**
     * 是
     * app名称
     */
    @ApiModelProperty("是 app名称")
    private String name;

    /**
     * 是
     * app bundle id
     */
    @ApiModelProperty("是 app bundle id ")
    private String bundle;

    /**
     * 是
     * app版本号
     */
    @ApiModelProperty("是 app版本号 ")
    private String ver;

    /**
     * 否
     * app类别
     */
    @ApiModelProperty("否 app类别")
    private String[] cat;

    /**
     * 否
     * 是否⽀支持deep link;
     * 0表示不不⽀支持，1表示⽀支持， 默认不不⽀支持
     */
    @JSONField(name = "support_deep_link")
    @ApiModelProperty("否 是否⽀支持deep link 0表示不不⽀支持，1表示⽀支持， 默认不不⽀支持")
    private Integer supportDeepLink;

    /**
     * 否
     * Publisher对象信息
     */
    @ApiModelProperty(hidden = true)
    private PublisherReq publisher;

}
