package com.bxm.localnews.thirdparty.param.bxm.advertisement.req;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("请求SSP的 device 信")
public class DeviceReq {

    /**
     * 是
     * 设备的ip
     */
    @ApiModelProperty("是 设备的ip")
    private String ip;

    /**
     * 是
     * user agent
     */
    @ApiModelProperty("是 user agent")
    String ua;

    /**
     * 是
     * 设备型号
     */
    @ApiModelProperty("是 设备型号")
    private String model;

    /**
     * 是
     * ⽣生产⼚厂商，例例如:"Samsung"
     */
    @ApiModelProperty("是 ⽣生产⼚厂商，例例如:Samsun")
    private String make;

    /**
     * 是
     * ⼿手机品牌
     */
    @ApiModelProperty("是 ⼿手机品牌")
    private String brand;

    /**
     * 是
     * 链接类型，空串串表示未知，wifi, 2g, 3g, 4g,5h， ethernet,cell_unknown
     */
    @JSONField(name = "connection_type")
    @ApiModelProperty("是 链接类型，空串串表示未知，wifi, 2g, 3g, 4g,5h， ethernet,cell_unknown")
    private String connectionType;

    /**
     * 是
     * 设备⽅方向，1:纵向，2:横向
     */
    @ApiModelProperty("是 设备⽅方向，1:纵向，2:横向")
    private Integer orientation;

    /**
     * 否
     * 运营商，0:移动，1:电信，3:联通，4:unknown
     */
    @ApiModelProperty("否 运营商，0:移动，1:电信，3:联通，4:unknown")
    private Integer carrier;

    /**
     * 否
     * MAC地址
     */
    @ApiModelProperty("否 MAC地址")
    private String mac;

    /**
     * 否
     * md5加密的MAC地址
     */
    @JSONField(name = "mac_md5")
    @ApiModelProperty("否 md5加密的MAC地址")
    private String macMd5;

    /**
     * 否
     * IMEI码
     */
    @ApiModelProperty("否 IMEI码")
    private String imei;

    /**
     * 否
     * md5加密的IMEI码
     */
    @JSONField(name = "imei_md5")
    @ApiModelProperty("否 md5加密的IMEI码")
    private String imeiMd5;

    /**
     * 否
     * imsi码
     */
    @ApiModelProperty("否 imsi码")
    private String imsi;

    /**
     * 否
     * Android ID
     */
    @JSONField(name = "android_id")
    @ApiModelProperty("否 Android ID")
    private String androidId;

    /**
     * 否
     * md5加密的Android ID
     */
    @JSONField(name = "android_id_md5")
    @ApiModelProperty("否 md5加密的Android ID")
    private String androidIdMd5;

    /**
     * 否
     * Android AD ID
     */
    @JSONField(name = "android_adid")
    @ApiModelProperty("否 Android AD ID")
    private String androidAdid;

    /**
     * 否
     * ios系统的idfa
     */
    @ApiModelProperty("否 ios系统的idfa")
    private String idfa;

    /**
     * 否
     * md5加密的ios系统的idfa
     */
    @JSONField(name = "idfa_md5")
    @ApiModelProperty("否 md5加密的ios系统的idfa")
    private String idfaMd5;


    /**
     * 是
     * 操作系统类型, "ios", "android", "wp"(windows phone)
     */
    @ApiModelProperty("是 操作系统类型, ios android wp(windows phone)")
    private String os;

    /**
     * 是
     * 操作系统版本
     */
    @JSONField(name = "os_version")
    @ApiModelProperty("是 操作系统版本")
    private String osVersion;

    /**
     * 否
     * 设备的屏幕信息
     */
    @ApiModelProperty(value = "否 设备的屏幕信息", hidden = true)
    private ScreenReq screen;

    /**
     * 否
     * 设备的位置信息
     */
    @ApiModelProperty(value = "否 设备的位置信息", hidden = true)
    private GeoReq geo;
}
