package com.bxm.localnews.thirdparty.param.bxm.advertisement.resp;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(description = "变现猫SSP广告")
public class AdResp {

    /**
     * 是
     * 广告id
     */
    @ApiModelProperty("是 广告id")
    private String id;

    /**
     * 是
     * ⼴告位id，与request中的place_token对应
     */
    @JSONField(name = "place_token")
    @ApiModelProperty("是 ⼴告位id，与request中的place_token对应")
    private String placeToken;

    /**
     * 是
     * 广告动作类型
     * {@link ActionClickType}
     */
    @ApiModelProperty("是 广告动作类型")
    private Integer action;

    /**
     * 是
     * ⼴告宽度
     */
    @ApiModelProperty("是 告宽度")
    private Integer w;

    /**
     * 是
     * 广告高度
     */
    @ApiModelProperty("是 广告高度")
    private Integer h;

    /**
     * 否
     * Android应⽤用为包名
     */
    @JSONField(name = "app_bundle")
    @ApiModelProperty("否 Android应")
    private String appBundle;

    /**
     * 否
     * 应用版本号
     */
    @JSONField(name = "app_ver")
    @ApiModelProperty("否 应用版本号")
    private String appVer;

    /**
     * 否
     * deeplink 链接
     */
    @JSONField(name = "deeplink_url")
    @ApiModelProperty("否 deeplink 链接")
    private String deeplinkUrl;

    /**
     * 是
     * ⽬目标地址, ⾥里里⾯面的宏需要予以替换
     */
    @JSONField(name = "target_url")
    @ApiModelProperty("是 ⽬目标地址, ⾥里里⾯面的宏需要予以替换")
    private String targetUrl;

    /**
     * 是
     * 当点击⼴广告时，监控URL列列表，应在后台访问, ⾥面的宏需要予以替换
     */
    @JSONField(name = "click_trackers")
    @ApiModelProperty("是 当点击⼴广告时，监控URL列列表，应在后台访问, ⾥面的宏需要予以替换")
    private String[] clickTrackers;

    /**
     * 是
     * 当⼴广告被展示时，监控URL列列表，应在后台访问, ⾥面的宏需要予以替换
     */
    @JSONField(name = "imp_trackers")
    @ApiModelProperty("是 当⼴广告被展示时，监控URL列列表，应在后台访问, ⾥面的宏需要予以替换")
    private String[] impTrackers;

    /**
     * 否
     * APP监测信息
     */
    @JSONField(name = "app_trackers")
    @ApiModelProperty("否 APP监测信息")
    private Object[] appTrackers;

    /**
     * 是
     * ⼴告创意类型
     */
    @ApiModelProperty("是 ⼴告创意类型")
    private Integer type;

    /**
     * 否
     * 广告价格，若没有该数据则为0, 单位为分
     */
    @ApiModelProperty("否 广告价格，若没有该数据则为0, 单位为分")
    private Float price;

    /**
     * 否
     * 原⽣生广告
     */
    @JSONField(name = "native")
    @ApiModelProperty("否 生广告")
    private NativeResp nativeObject;

    /**
     * 否
     * 保留字段
     */
    @ApiModelProperty("否 保留字段")
    private String ext;


}
