package com.bxm.localnews.thirdparty.param.bxm.advertisement.resp;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

@Data
public class VideoResp {

    /**
     * 是
     * 视频类型，1、原⽣生视频 2、激励视频
     */
    @JSONField(name = "video_type")
    private Integer videoType;

    /**
     * 否
     * 视频⻓长度。以毫秒为单位
     */
    private Integer duration;

    /**
     * 否
     * video元素的宽度，单位为像素。
     */
    private Integer w;

    /**
     * 否
     * video元素的⻓长度，单位为像素。
     */
    private Integer h;

    /**
     * 是
     * 视频的url
     */
    private String url;

    /**
     * 否
     * 视频⽂文件的封⾯面图
     */
    @JSONField(name = "cover_url")
    private String coverUrl;

    /**
     * 否
     * 视频格式
     */
    @JSONField(name = "mime_types")
    private String[] mimeTypes;

    /**
     * 否
     * 是否允许跳过视频。1:允许 2:不不允许
     */
    private Integer skip;

    /**
     * 否
     * 最⼩小播放时⻓长⻓长，以毫秒为单位，当且仅当skip=1 时必填
     */
    @JSONField(name = "skip_min")
    private Integer skipMin;

    /**
     * 否
     * 视频传递形式，0:不不限 1:实时 2:预加载
     */
    private Integer delivery;

    /**
     * 否
     * 视频的最⼤小，以KB为单位
     */
    @JSONField(name = "max_length")
    private Integer maxLength;

    /**
     * 否
     * 缓存视频⼴广告多长时间内有效，以毫秒为单位
     */
    @JSONField(name = "preload_time")
    private Integer preloadTime;

    /**
     * 否
     * 视频播放完成之后需要展示的endcard的url
     */
    @JSONField(name = "end_card_url")
    private Integer endCardUrl;

    /**
     * 否
     * 激励视频监测地址
     */
    @JSONField(name = "v_monitor")
    private VMonitor vMonitor;

}
