package com.bxm.localnews.thirdparty.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author gonzo
 * @date 2020-08-20 17:23
 **/
@Component
@ConfigurationProperties("thirdparty.config.adver")
@Data
public class AdverProperties {

    /**
     * 默认的邀请好友的海报图片地址
     */
    private String defaultInvitePosterUrl = "https://mtest.wstong.com/localnews_test/png/20200820/H8UKWHWUJEKIZ9MD0E8RY5E4IALZ1GKGWN2EK5.png";

    private Integer topShowcaseMaxSize = 3;

    /**
     * 新人商品池id
     */
    private Long novicePoolId = 30L;

    private String noviceCommodityUrl = "tk/index.html#/zero?userId={userId}";

    /**
     * 夺宝页
     */
    private String flowerGainTreasureUrl = "tk/raffle.html#/raffleIndex?userId={userId}&areaCode={areaCode}&areaName={areaName}&moreBtnType=3&btnTitle=%E5%A4%BA%E5%AE%9D%E6%94%BB%E7%95%A5";


    /**
     * 5折会员日页面
     */
    private String halfOffVipUrl = "tk/index.html#/vipHalfOff?userId={userId}&areaCode={areaCode}&areaName={areaName}";


    /**
     * 3.10.0版本 我的模块顶部banner需要处理的4个类型名称
     */
    private String myTopBannerMyTeam = "我的团队";
    private String myTopBannerMyEarnings = "我的收益";
    private String myTopBannerInviteFriends = "邀请好友";
    private String myTopBannerRedFlower = "红花商城";
}
