package com.bxm.localnews.thirdparty.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("thirdparty.config.adver.bxm")
@Data
public class BXMAdvertisementProperties {

    /**
     * 测试请求的标志，0表示不不是测试， 1表示测试， 默认不不是测试
     */
    private Integer test = 0;

    /**
     * 是否需要https链接的标识，默认为1，0标识不不需要，1标识需要。 当为1时，需要返回的所有素材及追踪链接必须是https链接
     */
    private Integer https = 1;

    /**
     * 变现猫ssp请求数据
     */
    private String bxmSspReq = "{\"ver\":\"0.1.1\",\"app\":{\"name\":\"wst\",\"bundle\":\"wangshitong\",\"ver\":\"3.0.0\"},\"device\":{\"os\":\"android\",\"os_version\":\"Lollipop\",\"model\":\"redmi\",\"ip\":\"115.206.13.64\",\"make\":\"mi\",\"brand\":\"mi\",\"connection_type\":1,\"orientation\":1,\"ua\":\"Mozilla/5.0 (Linux; U; Android 8.1.0; zh-cn; MI 5X Build/OPM1.171019.019) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.128 Mobile Safari/537.36 XiaoMi/MiuiBrowser/10.8.3\",\"imei\":\"ersltb3B1Yi1pb35NyDA31A0oabakBiJkfI42\",\"screen\":{\"w\":400,\"h\":1000}},\"ads\":[{\"floor_price\":1,\"w\":\"300\",\"h\":\"300\",\"place_token\":\"quanping\"}],\"test\":1}";
}
