package com.bxm.localnews.thirdparty.config;

import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * httpclient 连接管理器
 *
 * @author kakotor
 */
@Component
public class CustomApacheHttpClientBuilder implements ApacheHttpClientBuilder {
  protected final Logger log = LoggerFactory.getLogger(CustomApacheHttpClientBuilder.class);

  private final CloseableHttpClient closeableHttpClient;

  @Autowired
  public CustomApacheHttpClientBuilder(CloseableHttpClient closeableHttpClient) {
      this.closeableHttpClient = closeableHttpClient;
  }

  @Override
  public CloseableHttpClient build() {
    return this.closeableHttpClient;
  }

    @Override
    public ApacheHttpClientBuilder httpProxyHost(String httpProxyHost) {
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyPort(int httpProxyPort) {
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyUsername(String httpProxyUsername) {
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyPassword(String httpProxyPassword) {
        return this;
    }

    @Override
    public ApacheHttpClientBuilder sslConnectionSocketFactory(SSLConnectionSocketFactory sslConnectionSocketFactory) {
        return this;
    }
}
