package com.bxm.localnews.thirdparty.config;

import com.bxm.localnews.thirdparty.vo.OrderTab;
import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Data
@ConfigurationProperties("thirdparty.config.jump-info")
public class ThirdpartyJumpInfoProperties {

    /**
     * 订单tab的信息
     */
    private List<String> orderTabs = Lists.newArrayList();

    /**
     * 团油地址
     * %s占位符为手机号
     */
    private String oilUrl = "https://open.czb365.com/redirection/todo/?platformType=98643920&platformCode=%s";

    /**
     * 卡券地址
     */
    private String couponUrl = "";
}
