package com.bxm.localnews.thirdparty.config;

import com.bxm.localnews.thirdparty.dto.WechatMP;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 微信公众号信息
 * @author Gonzo
 * @date 2019-12-18 16:29
 */
@Component
@ConfigurationProperties(prefix = "thirdparty.config.wechat.mp")
@Data
public class WechatMPConfig {

    /**
     * 未选择场景的情况下，默认的启用信息
     */
    private Active active;

    /**
     * 各个不同场景对应的配置的appId
     */
    private Map<String, String> appIdByType = Maps.newHashMap();

    /**
     * 多个微信公众号信息 json字符串
     * @see WechatMP
     */
    private String wechatMps;

    @Data
    public static class Active {
        /**
         * 启用的公众号对应的appId
         */
        private String activeAppId;

        /**
         * 启用的公众号对应的域名
         */
        private Long activeDomainNameId;
    }
}
