package com.bxm.localnews.thirdparty.config;

import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.util.WxMpConfigStorageHolder;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;

/**
 * @author Gonzo
 * @date 2019-12-19 11:39
 */
@Slf4j
public class WechatMpServiceInvocationHandler implements InvocationHandler {

    private WxMpService wxMpService;

    private WechatMPConfig wechatMpConfig;

    public WechatMpServiceInvocationHandler(WxMpService wxMpService, WechatMPConfig wechatMpConfig) {
        this.wxMpService = wxMpService;
        this.wechatMpConfig = wechatMpConfig;
    }

    /**
     * 重新替换微信公众号service
     * 暂时弃用
     * @param wxMpService
     */
    @Deprecated
    public void setWxMpService(WxMpService wxMpService) {
        log.info("wechat mp service replaced, appid source: {}, target: {}",
            this.wxMpService.getWxMpConfigStorage().getAppId(), wxMpService.getWxMpConfigStorage().getAppId());
        this.wxMpService = wxMpService;
    }

    /**
     * 调用前，设置启用的公众号
     * @param proxy
     * @param method
     * @param args
     * @return
     * @throws Throwable
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {

        // 如果没有指定
        if (Objects.equals("default", WxMpConfigStorageHolder.get())) {
            // 使用当前配置的默认公众号
            WxMpConfigStorageHolder.set(wechatMpConfig.getActive().getActiveAppId());
        }

        if (log.isDebugEnabled()) {
            log.debug("使用的公众号配置: {}", WxMpConfigStorageHolder.get());
        }

        Object result;
        try {
            result =  method.invoke(wxMpService, args);
        } catch(Exception e) {
           throw e;
        } finally {
            // 置为初始状态...
            // FIXME 这里 如果是方法结束就重置 可能会导致一个业务中调用多次，就需要设置多次的情况 不合理
            // 这个应该放到后置拦截器中处理，在一个请求结束之后，置为default
            WxMpConfigStorageHolder.set("default");
        }

        return result;
    }
}
