package com.bxm.localnews.thirdparty.config;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import me.chanjar.weixin.mp.enums.TicketType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author zhaoyadong 2018/11/21 19:24
 * @desc
 */
public class WxMpInRedisConfigStorage extends WxMpInMemoryConfigStorage {

    private static final String ACCESS_TOKEN_KEY = "wechat_access_token_";

    private static final String JSAPI_TICKET_KEY = "wechat_jsapi_ticket_";

    private static final String CARDAPI_TICKET_KEY = "wechat_cardapi_ticket_";

    private final static Logger logger = LoggerFactory.getLogger(WxMpInRedisConfigStorage.class);

    private RedisStringAdapter redisStringAdapter;

    private String accessTokenKey;

    private String jsapiTicketKey;

    private String cardapiTicketKey;

    private CustomApacheHttpClientBuilder customApacheHttpClientBuilder;

    public WxMpInRedisConfigStorage(RedisStringAdapter redisStringAdapter,CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        this.redisStringAdapter = redisStringAdapter;
        this.customApacheHttpClientBuilder = customApacheHttpClientBuilder;
        setApacheHttpClientBuilder(customApacheHttpClientBuilder);
    }

    @Override
    public void setAppId(String appId) {
        super.setAppId(appId);
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(appId);
        this.jsapiTicketKey = JSAPI_TICKET_KEY.concat(appId);
        this.cardapiTicketKey = CARDAPI_TICKET_KEY.concat(appId);
    }

    private KeyGenerator getWxMpKey(String key) {
        return RedisConfig.WEIXIN_KEY.copy().appendKey(key);
    }

    @Override
    public String getAccessToken() {
        return redisStringAdapter.getString(getWxMpKey(this.accessTokenKey));
    }

    @Override
    public void expireAccessToken() {
        //token错误时，用于主动执行过期
        redisStringAdapter.remove(getWxMpKey(this.accessTokenKey));
        super.expireAccessToken();
    }

    @Override
    public boolean isAccessTokenExpired() {
        return !redisStringAdapter.hasKey(getWxMpKey(this.accessTokenKey));
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        redisStringAdapter.set(getWxMpKey(this.accessTokenKey), accessToken, expiresInSeconds - 200);
    }

    @Override
    public String getTicket(TicketType ticketType) {
        String jsapiTicket = redisStringAdapter.getString(getWxMpKey(this.jsapiTicketKey));
        logger.debug("[微信的票据:{}]", jsapiTicket);
        return jsapiTicket;
    }

    @Override
    public boolean isTicketExpired(TicketType ticketType) {
        logger.debug("[微信js的key:{}是否过期]", getWxMpKey(this.jsapiTicketKey));
        return !redisStringAdapter.hasKey(getWxMpKey(this.jsapiTicketKey));
    }

    @Override
    public synchronized void updateTicket(TicketType type, String ticket, int expiresInSeconds) {
        logger.debug("[微信js的key:{},票据：{}, 过期时间: {}]", getWxMpKey(this.jsapiTicketKey), ticket, expiresInSeconds - 200);
        redisStringAdapter.set(getWxMpKey(this.jsapiTicketKey), ticket, expiresInSeconds - 200);
    }
}
