package com.bxm.localnews.thirdparty.config;

import com.bxm.localnews.thirdparty.service.wx.focus.handler.WxMpSubscribeHandler;
import com.bxm.localnews.thirdparty.service.wx.focus.handler.WxMpUnsubscribeHandler;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 微信消息处理路由设置
 *
 * @author donghy
 */
@Configuration
public class WxMpMessageRouterConfig {

    @Autowired
    private WxMpService wxMpService;

    /**
     * 微信关注事件 具体处理类
     */
    @Autowired
    private WxMpSubscribeHandler wxMpSubscribeHandler;

    /**
     * 微信取消关注事件 具体处理类
     */
    @Autowired
    private WxMpUnsubscribeHandler wxMpUnsubscribeHandler;

    /**
     * 根据github项目要求路由配置方法 创建路由的单例并配置规则
     * 现已接入 关注/取消关注的event驱动方式
     *
     * @return 创建并初始化后的WxMpMessageRouter
     */
    @Bean
    public WxMpMessageRouter wxMpMessageRouter() {
        WxMpMessageRouter wxMpMessageRouter = new WxMpMessageRouter(wxMpService);
        wxMpMessageRouter
                //关注
                .rule()
                .msgType(WxConsts.XmlMsgType.EVENT)
                .event(WxConsts.EventType.SUBSCRIBE)
                .handler(wxMpSubscribeHandler)
                //需要设置为同步模式,才能正常返回关注之后的消息
                .async(false)
                .end()
                //取关
                .rule()
                .msgType(WxConsts.XmlMsgType.EVENT)
                .event(WxConsts.EventType.UNSUBSCRIBE)
                .handler(wxMpUnsubscribeHandler)
                .end();
        return wxMpMessageRouter;
    }
}
