package com.bxm.localnews.thirdparty.filter.position;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.UserTbkInfo;
import com.bxm.localnews.integration.CommodityInfoFacadeService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.config.DuoMaiMeituanProperties;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.dto.MeituanEuid;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertParam;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.taobao.api.request.TbkActivitylinkGetRequest;
import com.taobao.api.response.TbkActivitylinkGetResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 转化淘宝联盟官方活动链接
 * @author Gonzo
 * @date  2020-05-28 17:19
 * @since 1.0.0
 */
@Slf4j
@AdverFilter
public class ConvertAdverFilter extends AbstractAdvertFilterHandler {

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private CommodityInfoFacadeService commodityInfoFacadeService;

    @Autowired
    private DuoMaiMeituanProperties duoMaiMeituanProperties;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        attach(param, advertVOS);
        return true;
    }

    private void attach(AdvertisementParam param, List<AdvertVO> advertDtos) {
        if (Objects.isNull(param.getUserId())) {
            return;
        }

        advertDtos.forEach(p -> {
            if (Objects.nonNull(p)
                    // 表示该广告位要跳转淘宝联盟官方活动
                    && Objects.nonNull(p.getFollowAct()) && p.getFollowAct() == 3
                    && StringUtils.isNotBlank(p.getAdzoneId()) && StringUtils.isNotBlank(p.getFollowContent())) {
                // 用户的淘宝客 关系id
                UserTbkInfo tbkInfo = userIntegrationService.selectUserFromCacheByUserId(param.getUserId());
                if (Objects.isNull(tbkInfo) || StringUtils.isBlank(tbkInfo.getTbkRelationId())) {
                    return;
                }

                Long adzoneId = null, promotionSceneId = null;
                try {
                    adzoneId = Long.valueOf(p.getAdzoneId());
                    promotionSceneId = Long.parseLong(p.getFollowContent());
                } catch (Exception e) {
                    log.warn("类型转换失败，materialId: {} 的广告位配置有问题 无法转换淘宝联盟活动", p.getMaterialId());
                }

                if (Objects.nonNull(adzoneId) && Objects.nonNull(promotionSceneId)) {
                    // 获取淘宝联盟官方活动链接
                    String taoBaoUnionUrl = commodityInfoFacadeService.getTaoBaoUnion(adzoneId,
                            tbkInfo.getTbkRelationId(), promotionSceneId);

                    if (StringUtils.isNotBlank(taoBaoUnionUrl)) {
                        if (taoBaoUnionUrl.contains("https")) {
                            p.setAddress(StringUtils.isNotBlank(taoBaoUnionUrl)
                                    ? taoBaoUnionUrl.replaceAll("https", "wst://function/openApp?url=tbopen")
                                    : "");
                        } else {
                            p.setAddress(StringUtils.isNotBlank(taoBaoUnionUrl)
                                    ? taoBaoUnionUrl.replaceAll("http", "wst://function/openApp?url=tbopen")
                                    : "");
                        }
                    }

                }
            }
        });
    }

    /**
     * 获取美团跳转链接
     * @param userId
     * @return
     */
    private String meituanJumpUrl(Long userId) {
        MeituanEuid euid = new MeituanEuid();
        euid.setUserId(userId);
        euid.setTime(new Date());
        euid.setSiteId("LOCAL_NEWS");

        try {
            // http://c.duomai.com/track.php?site_id=47&aid=69&euid=&t=http%3A%2F%2Fwww.duomai.com%2F
            URIBuilder uriBuilder = new URIBuilder(duoMaiMeituanProperties.getTrackUrl());
            // 多麦的媒体id
            uriBuilder.addParameter("site_id", duoMaiMeituanProperties.getSiteId());
            // 美团的推广计划id
            uriBuilder.addParameter("aid", duoMaiMeituanProperties.getAid());
            // 自定义参数
            uriBuilder.addParameter("euid", JSON.toJSONString(euid));
            // 美团推广的目标地址
            uriBuilder.addParameter("t", duoMaiMeituanProperties.getTargetUrl());

            return uriBuilder.build().toString();
        } catch(Exception e) {
            log.error("", e);
        }


        return "";
    }

}
