package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.UserRegisterInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.enums.DeliveryCrowdEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

import static java.lang.Boolean.TRUE;
import static java.util.Objects.isNull;

/**
 * 投放人群控制
 *
 * @author: gengyy
 * @create: 2020-10-28 15:11
 */

@Slf4j
@AdverFilter
@AllArgsConstructor
public class DeliveryCrowdAdverFilter extends AbstractAdvertFilterHandler {

    private final UserIntegrationService userIntegrationService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        List<AdvertVO> newAdvertList = new ArrayList<>();

        // 避免不必要的查询
        AtomicReference<Boolean> newUser = new <Boolean>AtomicReference();
        AtomicReference<Boolean> isVip = new <Boolean>AtomicReference();
        AtomicReference<Boolean> taokNovice = new <Boolean>AtomicReference();
        UserInfoDTO userInfo = param.getUserInfo();
        if (Objects.isNull(userInfo)) {
            UserInfoDTO userFromRedisDB = userIntegrationService.getUserFromRedisDB(param.getUserId());
            param.setUserInfo(userFromRedisDB);
            userInfo = userFromRedisDB;
        }
        UserInfoDTO finalUserInfo = userInfo;
        if (Objects.isNull(userInfo)) {
            return true;
        }
        advertVOS.forEach(advertVO -> {
            //全部人群
            if (advertVO.getDeliveryCrowd() == null || Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.ALL_CROWD.getType())) {
                newAdvertList.add(advertVO);
            }
            //如果为新用户
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.NEW_USER.getType())) {
                if (isNull(newUser.get())) {
                    newUser.set(initNewUserInfo(param.getUserId()));
                }
                if (Objects.equals(newUser.get(), TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            //如果为新用户
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.OLD_USER.getType())) {
                if (isNull(newUser.get())) {
                    newUser.set(initNewUserInfo(param.getUserId()));
                }
                if (!Objects.equals(newUser.get(), TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            //如果为vip
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.VIP_USER.getType())) {
                if (isNull(isVip.get())) {
                    isVip.set(userIntegrationService.checkUserIsVip(param.getUserId()));
                }
                if (Objects.equals(isVip.get(), TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            //如果为非vip
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.NO_VIP_USER.getType())) {
                if (isNull(isVip.get())) {
                    isVip.set(userIntegrationService.checkUserIsVip(param.getUserId()));
                }
                if (!Objects.equals(isVip.get(), TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            // 淘客新人
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.TK_NEW_CROWD.getType())) {
                if (isNull(taokNovice.get())) {
                    taokNovice.set(taokNew(finalUserInfo));
                }
                if (Objects.equals(taokNovice.get(), TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            // 非淘客新人
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.TK_CROWD.getType())) {
                if (isNull(taokNovice.get())) {
                    taokNovice.set(taokNew(finalUserInfo));
                }
                if (!Objects.equals(taokNovice.get(), TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            //如果达人
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.TALENT.getType()) && !Objects.equals(finalUserInfo.getTalentLevel(), 0)) {
                newAdvertList.add(advertVO);
            }
            //如果非达人
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.NO_TALENT.getType()) && Objects.equals(finalUserInfo.getTalentLevel(), 0)) {
                newAdvertList.add(advertVO);
            }
        });
        advertVOS.clear();
        advertVOS.addAll(newAdvertList);
        return true;
    }

    private boolean initNewUserInfo(Long userId) {
        boolean newUser;
        UserRegisterInfoDTO userRegisterInfoDTO = userIntegrationService.userRegisterInfo(userId);
        if (userRegisterInfoDTO != null) {
            Date firstLoginDate = userRegisterInfoDTO.getFirstLoginTime();
            newUser = firstLoginDate != null && DateUtils.isSameDay(firstLoginDate, new Date());
        } else {
            newUser = false;
        }

        return newUser;
    }

    /**
     * 用户是否淘客新人
     *
     * @param userInfo 用户信息
     * @return true: 是淘客新人
     */
    private boolean taokNew(UserInfoDTO userInfo) {
        return isNull(userInfo.getJudgeMarker()) || !BitOperatorUtil.getBitAsBoolean(userInfo.getJudgeMarker(), LocalNewsUserJudgeMarkerEnum.HAS_ORDERED.getIndex());
    }

}
