package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.gexin.fastjson.JSON;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

import static com.gexin.fastjson.JSON.toJSONString;

/**
 * 邀请好友分享海报广告位的处理
 *
 * @author gonzo
 * @date 2020-08-20 17:14
 **/
@Slf4j
@AllArgsConstructor
@AdverFilter(AdvertTypeEnum.INVITE_POSTER_SHARE)
public class InvitePositionAdverFilter extends AbstractAdvertFilterHandler {

    private final AdverProperties adverProperties;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        // 判断当前广告位是否有数据
        if (CollectionUtils.isEmpty(advertVOS)) {
            // 没数据 判断是否是空
            if (Objects.isNull(advertVOS)) {
                // null 就没办法处理了
                log.warn("获取邀请好友分享海报的广告失败，广告列表为空，无法添加默认广告, 请求参数: {}", toJSONString(param));
                return false;
            }

            // 空 构造一个默认图片地址的广告对象返回
            AdvertVO advertVO = new AdvertVO();
            advertVO.setImgUrl(adverProperties.getDefaultInvitePosterUrl());
            advertVO.setTitle("默认邀请好友图片");
            advertVOS.add(advertVO);
        }

        return true;
    }
}
