package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.filter.position.myTopStrategy.MyTopBannerContextProcess;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author: lowi
 * @date: 2020-09-17 18:51
 */
@AdverFilter(AdvertTypeEnum.MY_TOP_BANNER)
@Slf4j
@AllArgsConstructor
public class MyTopBannerFilter extends AbstractAdvertFilterHandler {

    private final MyTopBannerContextProcess contextProcess;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        //我的页面,球区去掉“我的团队”和“我的收益”，
        //换成“邀请拿现金”，
        advertVOS.removeIf(advert -> removeSpecificType(advert, param));
        return true;
    }

    private boolean removeSpecificType(AdvertVO advertVO, AdvertisementParam param) {
        return contextProcess.removeInfo(advertVO, param);
    }
}
