package com.bxm.localnews.thirdparty.filter.position;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 手机号码投放链接过滤,将其中的占位符替换为当前用户的手机号码
 *
 * @author liujia
 * @date 2020-07-21 14:22
 **/
@Slf4j
@AdverFilter
public class PhoneReplaceAdvertFilter extends AbstractAdvertFilterHandler {

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        for (AdvertVO advertVO : advertVOS) {
            String address = advertVO.getAddress();

            if (StringUtils.contains(address, "{phone}")) {
                UserInfoDTO userInfo = param.loadCacheUserInfo();

                if (StringUtils.isBlank(userInfo.getPhone())) {
                    log.info("用户[{}]不存在手机号码,用户信息为：{}", param.getUserId(), JSON.toJSONString(userInfo));
                } else {
                    advertVO.setAddress(StringUtils.replace(address, "{phone}", userInfo.getPhone()));

                    if (StringUtils.isNotBlank(advertVO.getFollowContent())) {
                        advertVO.setFollowContent(StringUtils.replace(advertVO.getFollowContent(),
                                "{phone}",
                                userInfo.getPhone()));
                    }
                }
            }
        }
        return true;
    }
}
