package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.config.KfcProperty;
import com.bxm.localnews.thirdparty.constant.AdverFollowAct;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.util.SignUtils;
import com.bxm.localnews.thirdparty.util.UrlParamsUtils;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import static com.google.common.base.Charsets.UTF_8;
import static org.apache.commons.lang3.StringUtils.join;

/**
 * 转化淘宝联盟官方活动链接
 *
 * @author Gonzo
 * @date 2020-05-28 17:19
 * @since 1.0.0
 */
@Slf4j
@AdverFilter
public class QianZhuAdverFilter extends AbstractAdvertFilterHandler {

    @Autowired
    private KfcProperty kfcProperty;

    private static final String WEB_PROTOCOL = "wst://web/webDetail?url=";

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        attach(param, advertVOS);
        return true;
    }

    private void attach(AdvertisementParam param, List<AdvertVO> advertDtos) {
        if (Objects.isNull(param.getUserId())) {
            return;
        }

        advertDtos.forEach(p -> {
            if (Objects.nonNull(p)
                    // 表示该广告位要跳转千猪肯德基
                    && Objects.nonNull(p.getFollowAct()) && p.getFollowAct() == AdverFollowAct.QIANZHU_KFC.getFollowAct()) {
                UserInfoDTO userInfoDTO = param.loadCacheUserInfo();

                String nickName = Objects.isNull(userInfoDTO) ? "" : userInfoDTO.getNickname();
                try {
                    // 名称需要url编码
                    Map<String, Object> signMap = Maps.newHashMap();
                    signMap.put("platformUniqueId", param.getUserId());
                    signMap.put("nickname", nickName);
                    signMap.put("platformId", kfcProperty.getPlatformId());
                    signMap.put("timestamp", System.currentTimeMillis());
                    signMap.put("redirectUrl", "");

                    String sign = SignUtils.generateSign(signMap, kfcProperty.getSecret());
                    signMap.put("sign", sign);
                    String paramStr = UrlParamsUtils.toParams(signMap);

                    String url = URLEncoder.encode(join(kfcProperty.getServerUrl(), "/api/v2/platform/login?", paramStr), UTF_8.name());
                    // IOS使用的url decode标准和android 服务端不一致导致对空格的解析错误，这里进行替换
                    url = url.replace("+", "%20");

                    p.setAddress(WEB_PROTOCOL + url);
                } catch (Exception e) {
                    log.error("获取千猪肯德基点餐地址失败", e);
                }
            }
        });
    }
}
