package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 开屏广告的处理
 *
 * @author Gonzo
 * @date  2020-09-27 11:12
 */
@Slf4j
@AdverFilter({AdvertTypeEnum.START_SCREEN})
public class StartScreenAdverFilter extends AbstractAdvertFilterHandler {

    @Autowired
    RedisStringAdapter redisStringAdapter;

    @Autowired
    UserIntegrationService userIntegrationService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        // 开屏广告可以配置多个，但客户端只会选择第一个进行弹出，所以这里将列表的数据进行随机选用，配置到第一个里面
        if (!CollectionUtils.isEmpty(advertVOS) && advertVOS.size() > 1) {
            // 随机获取一个
            int index = RandomUtils.nextInt(0, advertVOS.size());

            if (log.isDebugEnabled()) {
                log.debug("开屏广告有: {}个，随机选用角标: {}的幸运儿展示", advertVOS.size(), index);
            }

            AdvertVO adv = advertVOS.get(index);
            // 移除非当前选中的开屏广告
            advertVOS.removeIf(p -> !Objects.equals(p.getMaterialId(), adv.getMaterialId()));
        }

        return true;
    }
}
