package com.bxm.localnews.thirdparty.filter.position;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;

import java.util.List;

import static com.bxm.localnews.thirdparty.constant.AdvertTypeEnum.*;

/**
 * @author lowi
 * @date 2020/11/20 18:11
 */
@AdverFilter({TOUTIAO_ADVERT_FIRST, TOUTIAO_ADVERT_SECOND, TOUTIAO_ADVERT_THIRD})
public class ToutiaoAdvertFilter extends AbstractAdvertFilterHandler {

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        advertVOS.forEach(advertVO -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tag", advertVO.getMaterialContent() == null ? "广告" : advertVO.getMaterialContent());
            advertVO.setExtData(jsonObject);
        });
        return true;
    }
}
